# NOTE: Derived from ../blib/lib/Fan/Attrib.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan::Attrib;

#line 628 "../blib/lib/Fan/Attrib.pm (autosplit into ../blib/lib/auto/Fan/Attrib/from_list.al)"
;#
;# parsing a line from outputs of `ls', and return a reference
;#
sub from_list ($$) {
	my $y = shift;
	local $_ = shift;
	local($[); # for zero based array

	# cleanup first.
	$y->cleanup;

	# make backup of input line.
	my $x = $_;

	# DOS dirstyle - DOS like timestamp
	if (/^\d\d-\d\d-\d\d\s+\d\d:\d\d(am|pm)?/i) { # DOS
		my $date = $&;
		$_ = $';
		if (s/\s+\<DIR\>\s+//) {
			$y->{y_type}	= 'D';
			$y->{y_name}	= $_;
			return $y;
		}
		if (s/\s+(\d+)\s+//) {
			$y->{y_type}	= 'F';
			$y->{y_size}	= $1;
			$y->{y_date}	= $date;
			$y->{y_time0}	= &parsetime($date);
			$y->{y_name}	= $_;
			return $y;
		}
		debug(6, "unknown DOS format: \"$x\"\n"), return undef;
	}

	# UNIX style - cut file modes first, thanks to Shigechika AIKAWA.
	s/^ ?(.)([-r][-w].[-r][-w].[-r][-w].)\s*//
		or debug(7, "invalid format: \"$x\"\n"), return undef;

	# save filetype and mode string.
	my $type = $1;
	my $tmp = $2;

	# convert mode string to octal value
	my $mode = 0;
	$mode |= 04000 if $tmp =~ /^..[sS]/;
	$mode |= 02000 if $tmp =~ /^.....[sS]/;
	$mode |= 01000 if $tmp =~ /^........[tT]/;
	$mode |= 00400 if $tmp =~ /^r/;
	$mode |= 00200 if $tmp =~ /^.w/;
	$mode |= 00100 if $tmp =~ /^..[xs]/;
	$mode |= 00040 if $tmp =~ /^...r/;
	$mode |= 00020 if $tmp =~ /^....w/;
	$mode |= 00010 if $tmp =~ /^.....[xs]/;
	$mode |= 00004 if $tmp =~ /^......r/;
	$mode |= 00002 if $tmp =~ /^.......w/;
	$mode |= 00001 if $tmp =~ /^........[xs]/;
	$mode &= 0777; # for security reason, mask is required.

	# find date string, and save some values
	# $regexp_month = 'Jun|Feb|...|Dec'
	# $regexp_t = '(\d+:\d+:\d+\s+\d\d\d\d)|(\d\d\d\d)|(\d+:\d+)';
	/($regexp_month)\s+(\d?\d)\s+($regexp_t)/i
		or debug(7, "date not found: \"$x\"\n"), return undef;
	my($zz, $date, $file) = ($`, $&, $');

	# get size
	$zz =~ s/\s*(\d+)\s*$//
		or debug(7, "size not found: \"$x\"\n"), return undef;
	my $size = $1;

	# get link count
	$zz =~ s/^(\d+)\s*//
		or debug(7, "nlink not found: \"$x\"\n"), return undef;
	my $nlink = $1;

	# and get owner (and group)
	my($uid, $gid) = $zz =~ /\s+/ ? ($`, $') : ($zz, undef);

	# set filename to $_
	$_ = $file;

	# kill leading/trailing spaces, and trailing slash
	s/^\s+//; s/\s+$//; s/\/$//;

	# logging
	if ($LOG > 7) {
		debug(8, "parsing [$x]\n");
		debug(8, " ... filename = $_\n");
		debug(8, " ... type = $type\n");
		debug(8, " ... mode = ".sprintf("%04o", $mode)."\n");
		debug(8, " ... owner = $uid\n");
		debug(8, " ... group = $gid\n") if defined($gid);
		debug(8, " ... size = $size\n");
		debug(8, " ... date = $date\n");
		my @a = reverse((gmtime(&parsetime($date)))[0..5]);
		$a[0] += 1900;
		$a[1]++;
		debug(8, " ... time = ".
			sprintf("%04d-%02d-%02d %02d:%02d:%02d\n", @a));
	}

	# set common parameter
	$y->{y_perm}	= $mode;
	$y->{y_owner}	= $uid;
	$y->{y_group}	= $gid if defined($gid);

	# check file types.
	if ($type eq 'd') {
		debug(8, "parse: directory $_\n");
		$y->{y_type}	= 'D';
	} elsif ($type eq 'l') {
		my $linkto;
		($_, $linkto) =/\s+->\s+/ ? ($`, $') : ($_, '');
		debug(8, "parse: symlink $_ -> $linkto\n");
		$y->{y_type}	= 'L';
		$y->{y_linkto}	= $linkto;
	} elsif ($type eq '-') {
		debug(8, "parse: file $_\n");
		$y->{y_type}	= 'F';
		$y->{y_size}	= $size;
		$y->{y_date}	= $date;
		$y->{y_time0}	= &parsetime($date);
	} else {
		debug(7, "parse: unknown filetype [$type] for $_\n");
		return undef;
	}

	# ignore files who have invalid name
	if ($_ eq '' || $_ eq '.' || $_ eq '..') {
		warn("$_: invalid file name.\n") if $LOG > 6;
		return undef;
	}

	# store filename
	$y->{y_name}	= $_;

	# return this attribute object.
	$y;
}

# end of Fan::Attrib::from_list
1;
