# NOTE: Derived from ../blib/lib/Fan/Attrib.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan::Attrib;

#line 766 "../blib/lib/Fan/Attrib.pm (autosplit into ../blib/lib/auto/Fan/Attrib/parsetime.al)"
;# parse date strings and convert to time_t
sub parsetime ($) {
	local $_ = shift;

	my($sec, $min, $hour, $day, $mon, $year) =
	/^($regexp_month)\s+(\d+)\s+((\d\d\d\d)|((\d+):(\d+)))$/oi ?
		(0, $7, $6, $2, $1, $4) : # Unix ls
	/^($regexp_month)\s+(\d+)\s+(\d+):(\d+):(\d+)\s+(\d\d\d\d)$/oi ?
		($5, $4, $3, $2, $1, $6) : # Unix ls -T
	/^(\d+)\s+($regexp_month)\s+((\d\d\d\d)|((\d+):(\d+)))$/oi ?
		(0, $7, $6, $1, $2, $4) : # dls and NetWare
	/(\d+)-(\d+)-(\d+)\s+(\d+):(\d+)(AM|PM)?/oi ?
		(0, $5, ($6 eq 'PM' ? $4 + 12 : $4) , $2, $1, $3) :
	/(\d+)-(\S+)-(\d+)\s+(\d+):(\d+)/oi ?
		(0, $5, $4, $1, $2, $3) : # VMS style
	/^\w+\s+($regexp_month)\s+(\d+)\s+(\d+):(\d+):(\d+)\s+(\d+)/oi ?
		($5, $4, $3, $2, $1, $6) : # CTAN style (and HTTP)
	/^\w+,\s+(\d+)-($regexp_month)-(\d+)\s+(\d+):(\d+):(\d+)/oi ?
		($6, $5, $4, $1, $2, $3) : # another HTTP
	(); # undef...

	# convert month to index. 
	my $month = ($mon =~ /^\d+$/ ? $& - 1 : $nametomonth{lc $mon});

	# if year is not defined, use THIS year.
	if (!defined($year) || $year !~ /\d\d\d\d/) {
		my($l_month, $l_year) = (gmtime)[4, 5];
		$year = $l_year;
		$year-- if $month > $l_month;
	} elsif ($year < 1970) {
		# if timestamp is too old, something wrong will happen.
		return 0 if $year < 1970;
	}

	# is this system dependant?
	$year -= 1900 if $year >= 1970;

	# check illegal sec/min/hour values.
	$sec = 0 unless defined($sec) && $sec >= 0 && $sec < 60;
	$min = 0 unless defined($min) && $min >= 0 && $min < 60;
	$hour = 0 unless defined($hour) && $hour >= 0 && $hour < 24;

	# return time value in GMT.
	return mktime($sec, $min, $hour, $day, $month, $year) + $tzoff;
}

;# end of Fan::Attrib module
1;
# end of Fan::Attrib::parsetime
