# NOTE: Derived from ../blib/lib/Fan/Attrib.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan::Attrib;

#line 475 "../blib/lib/Fan/Attrib.pm (autosplit into ../blib/lib/auto/Fan/Attrib/to_line.al)"
;#
sub to_line ($) {
	my $y = shift;
	my $f = $y->{y_flag};
	my $t = $y->{y_type};
	my $b = '';	# for buffer
	my $x;		# for any

	return $f.$t if $t eq 'U' || $t eq '.';

	if (defined($x = $y->{y_perm})) {
		$b .= sprintf(" p=%04o", $x);
	}
	if (defined($x = $y->{y_owner})) {
		$b .= " o=$x";
		$b .= ".".$x if defined($x = $y->{y_group});
	}
	if (defined($x = $y->{y_mtime})) {
		$b .= " m=$x";
	}
	if ($t eq 'L' && defined($x = $y->{y_linkto})) {
		$b .= " l=".attr_encode($x);
	}
	if ($t eq 'F') {
		$b .= " s=$x" if defined($x = $y->{y_size});
		if ($x > 0) {
			$b .= " c=$y->{y_checksum}"
				if defined($x = $y->{y_checksum});
		}
	}
	$f.$t.$b." ".attr_encode($y->{y_name});
}

# end of Fan::Attrib::to_line
1;
