# NOTE: Derived from ../blib/lib/Fan/Attrib.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan::Attrib;

#line 262 "../blib/lib/Fan/Attrib.pm (autosplit into ../blib/lib/auto/Fan/Attrib/validate.al)"
;#
;# Validate an Attrib object.
;# If any unexpected case occurs, validate returns undef.
;#
sub validate ($) {
	my $y = shift;
	my $t = $y->{y_type}; # for type abbrev.

	# debug log
	debug(8, "* validate $y\n");

	# check type first.
	if (!defined($t)) { # type must be defined.
		confess("$y has no type, panic...");
	} elsif ($t !~ /^[.DFLU]$/) { # normal types
		carp("$y has wrong type: $t");
		return undef;
	} else {
		debug(8, " check ok: type = $t\n");
	}

	# terminator is always success.
	return 1 if $t eq '.';

	# check relative pathname if exists.
	if (!defined($y->{y_path})) { # anything is ok
		debug(8, " check ok: no path\n");
	} else {
		debug(8, " check ok: path = $y->{y_path}\n");
	}

	# check real pathname if exists.
	if (!defined($y->{y_realpath})) { # anything is ok
		debug(8, " check ok: no realpath\n");
	} else {
		debug(8, " check ok: realpath = $y->{y_realpath}\n");
	}

	# check of the type UP stair.
	if (!defined($y->{y_name})) {
		if ($t eq 'U') {
			debug(8, " check ok: no name (type U)\n");
		} else {
			carp("$y has no name");
			return undef;
		}
	} else {
		my $n = $y->{y_name};

		# invalid name causes security problems...
		if ($n ne '' && $n ne '..' && $n !~ /\//) {
			debug(8, " check ok: name = $n\n");
		} else {
			carp("$y has wrong name: $n");
			return undef;
		}
	}

	# check flags if exists
	if (!defined($y->{y_flag})) {
		debug(8, " check ok: no flag\n");
	} elsif ($y->{y_flag} =~ /^[-+=!]?$/) {
		debug(8, " check ok: flag = $y->{y_flag}\n");
	} else {
		carp("$y has wrong flag: $y->{y_flag}");
		return undef;
	}

	# check size if exists
	if (!defined($y->{y_size})) {
		debug(8, " check ok: no size\n");
	} elsif ($y->{y_size} =~ /^\d+$/) {
		debug(8, " check ok: size = $y->{y_size}\n");
	} else {
		carp("$y has wrong size: $y->{y_size}");
		return undef;
	}

	# check checksum values
	if (!defined($y->{y_checksum})) {
		debug(8, " check ok: no checksum\n");
	} elsif ($y->{y_checksum} =~ /^[a-f0-9]{32}$/) {
		debug(8, " check ok: checksum = $y->{y_checksum}\n");
	} else {
		carp("$y has wrong checksum: $y->{y_checksum}");
		return undef;
	}

	# check linkto
	if (!defined($y->{y_linkto}) && $t eq 'L') {
		carp("$y has no linkto (type L)");
		return undef;
	} elsif (!defined($y->{y_linkto})) {
		debug(8, " check ok: no linkto\n");
	} else {
		debug(8, " check ok: linkto = $y->{y_linkto}\n");
	}

	# check permission if exists
	if (!defined($y->{y_perm})) {
		debug(8, " check ok: no perm\n");
	} elsif ($y->{y_perm} =~ /^\d+$/) {
		debug(8, " check ok: perm = $y->{y_perm}\n");
	} else {
		carp("$y has wrong perm: $y->{y_perm}");
		return undef;
	}

	# check owner
	if (!defined($y->{y_owner})) {
		debug(8, " check ok: no owner\n");
	} elsif ($y->{y_owner} =~ /^[-_\w]+$/) {
		debug(8, " check ok: owner = $y->{y_owner}\n");
	} else {
		carp("$y has wrong owner: $y->{y_owner}");
		return undef;
	}

	# check group
	if (!defined($y->{y_group})) {
		debug(8, " check ok: no group\n");
	} elsif ($y->{y_group} =~ /^[-_\w]+$/) {
		debug(8, " check ok: group = $y->{y_group}\n");
	} else {
		carp("$y has wrong group: $y->{y_group}");
		return undef;
	}

	# check modification time
	if (defined($y->{y_mtime})) {
		if ($y->{y_mtime} =~ /^\d+$/) {
			debug(8, " check ok: mtime = $y->{y_mtime}\n");
		} else {
			carp("$y has wrong mtime: $y->{y_mtime}");
			return undef;
		}
	} elsif (defined($y->{y_time0})) {
		if ($y->{y_time0} =~ /^\d+$/) {
			debug(8, " check ok: time0 = $y->{y_time0}\n");
		} else {
			carp("$y has wrong time0: $y->{y_time0}");
			return undef;
		}
	} else { # no time information
		debug(8, " check ok: no time information\n");
	}

	# one more debug log
	debug(8, " validation ok.\n");

	# validation o.k.
	1;
}

# end of Fan::Attrib::validate
1;
