# NOTE: Derived from ../blib/lib/Fan/Cool.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan::Cool;

#line 217 "../blib/lib/Fan/Cool.pm (autosplit into ../blib/lib/auto/Fan/Cool/plock.al)"
;#
;# Usage: plock($filename, $timeout)
;#
;# An implementation of a lock mechanizem. `plock' uses `link'
;# function to lock a file, but uses no flock/lockf functions.
;# Second argument $timeout means how long seconds you may wait
;# until get lock. The default value of $timeout is 10[sec].
;#
sub plock ($;$) {
	my $file = shift;
	my $tt = @_ ? shift : 0;
	my $res = 0;
	local *FILE;

	;# generate temporary filename
	my $temp = $file;
	$temp =~ s,[^/]+$,.LOCK.$$, || return undef;

	;# check timeout value
	$tt = 10 if $tt < 1;

	;# make sure that temporary file does not exist
	for (; -e $temp && !unlink($temp) && $tt > 0; $tt--) {
		sleep(1);
	}

	;# create temporary file with process id
	$tt > 0 && open(FILE, ">$temp")
		&& (print FILE "$$\n")
		&& close(FILE)
		or unlink($temp), return undef;

	;# link it to target file
	for (; !($res = link($temp, $file)) && $tt > 0; $tt--) {
		my $pid;

		if (open(FILE, $file)
		     && chomp($pid = <FILE>)
		     && close(FILE)
		     && $pid =~ /^\d+$/) { # Got pid!
			if (kill(0, $pid)) { # Success to kill
				sleep(1); # wait a second
			} elsif (ESRCH != $!) {
				last; # permission denied? or other errors
			} else {
				unlink($file); sleep(1); # no need to sleep?
			}
		} else {
			unlink($file); sleep(1); # no need to sleep?
		}
	}

	;# unlink temporary file
	unlink($temp);

	;# result - success if link succeeded
	return $res;
}

# end of Fan::Cool::plock
1;
