# NOTE: Derived from ../blib/lib/Fan/DIR.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan::DIR;

#line 195 "../blib/lib/Fan/DIR.pm (autosplit into ../blib/lib/auto/Fan/DIR/fill.al)"
;#
;# fill directory information to $self->{dir_hash}.
;# make_dirinfo sets values of begin-update / end-update for directories
;# if and only if old dirinfo contains them.
;# Other values are re-generated by make_dirinfo.
;#
sub fill ($$) {
	my $self = shift;
	my $dir = shift;

	# Calculating MD5 checksum is very slow...
	# We can choose calculate it or not.
	my $no_md5 = $self->{ignore_md5checksum};

	local(*DIR, $[, $_);

	# check directory
	$dir ne '' && -d $dir
		or warn("dir is not a directory"), return undef;

	# get directory entries
	opendir(DIR, $dir)
		or carp("opendir($dir): $!"), return undef;
	my @list = sort readdir(DIR);
	closedir(DIR);

	# DO NOT clear my entries...
	# $self->{dir_hash} = {};
	$self->{dir_array} = [];

	# checking all entries
	my $file;
	for $file (@list) {
		next if $file eq '' || $file eq '.' || $file eq '..';
		next if $file =~ /^\.dirinfo/;
		next if $file =~ /\//;
		my $z = $self->get($file);
		my $y = Fan::Attrib->new(attr_path => "$dir/$file");
		unless (defined($y) && ref($y) eq 'Fan::Attrib') {
			warn("Can't create attrib object."), next;
		}
		$y->fill_checksum;
		if ($z) {
			$z->copyfrom($y); # in overwrite mode.
		} else {
			$self->add($y);
		}
# warn("fill: $file... added\n") if $LOG > 7;
		push(@{$self->{dir_array}}, $file); # register file name
	} # end of for $file (@list) { ... }

	#
	1;
}

# end of Fan::DIR::fill
1;
