# NOTE: Derived from ../blib/lib/Fan/DIR.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan::DIR;

#line 328 "../blib/lib/Fan/DIR.pm (autosplit into ../blib/lib/auto/Fan/DIR/update.al)"
;#
;# update dirinfo recursively
;# update_dirinfo returns 1 iff any change was found.
;#
sub update {
	my $self = shift;
	my $dir = @_ ? shift : $self->{dir_path};
	local(*DIR, $[, $_);
	my($old, $new, @stat, @list);
	my $dirinfo = "$dir/.dirinfo";

	# check directory
	$dir ne '' && -d $dir
		or warn("dir is not a directory"), return undef;

	# generate entires.
	$self->load($dir); # load old values...
	$self->fill($dir); # and merge new values.

	# entries...
	my $file;
	for $file (@{$self->{dir_array}}) {
		next if $file eq '' || $file eq '.' || $file eq '..';
		next if $file =~ /^\.dirinfo/;
		next if $file =~ /\//;	# must not contain '/'

		my $y = $self->get($file);
		next if $y->type ne 'D';

		my $t = time; # current time.
		my $kid = $self->new;

		if ($kid->update("$dir/$file") ||
			!defined($y->{y_begin_update}) ||
			!defined($y->{y_end_update})) {
			$y->{y_begin_update} = $t;
			$y->{y_end_update} = time;
		}
	} # end of for $file (@list) { ... }

	# return value is that of store.
	$self->store($dir);
}

# end of Fan::DIR::update
1;
