# NOTE: Derived from ../blib/lib/Fan/FTP.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan::FTP;

#line 246 "../blib/lib/Fan/FTP.pm (autosplit into ../blib/lib/auto/Fan/FTP/login.al)"
;#
sub login ($) {
	my $self = shift;
	my $i = $self->{ftp_login_retry};

	# log...
	warn("login: connecting to the server...\n") if $LOG > 4.5;

	# loop for retries...
	do {
		# try login
		if ($self->do_login) { # success to login
			warn("login: success.\n") if $LOG > 4.5;
			return 1;
		}

		# check result code
		if ($self->{lastcode} != 421) {
			$self->error($self->{lastmesg});
			return undef;
		}

	} while ($i-- > 0 && sleep($self->{ftp_retry_delay})) ;

	# retry timed out
	warn("login: too many login failure, gave up.\n") if $LOG > 4.5;
	$self->error("too many login failure, ".$self->{lastmesg});
	undef;
}

# end of Fan::FTP::login
1;
