# NOTE: Derived from ../blib/lib/Fan/FTP.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan::FTP;

#line 449 "../blib/lib/Fan/FTP.pm (autosplit into ../blib/lib/auto/Fan/FTP/pasv.al)"
;#
;# open passive socket
;#
sub pasv ($) {
	my $self = shift;

	$self->clearerror	&&
	$self->cleardataconn	|| return undef;

	my $family = ($self->sockname)[2];
	my ($a_regexp, $command);
	if ($family == AF_INET) {
		$a_regexp = '\((\d+),(\d+),(\d+),(\d+),(\d+),(\d+)\)';
		$command = 'PASV';
	} else {
		$a_regexp = '\([^\d\s]{3}(\d+)[^\d\s]\)';
		$command = 'EPSV';
	}
	if ($self->putreq($command) !~ /^2/) {
		$self->error($self->{lastmesg});
		return undef;
	}
	if ($self->{lastmesg} !~ $a_regexp) {
		$self->error("pasv: no ADDR,PORT pair found");
		return undef;
	}

	my $bindaddr = $self->{ftp_bindaddr};
	my ($port, $addr);
	if ($family == AF_INET) {
		$port = $5 * 256 + $6;
		$addr = join('.', $1, $2, $3, $4);
	} else {
		$port = $1;
		$addr = ($self->peername)[1];
	}
	my $data = Fan::TCP->new();

	$data && $data->do_client(
		tcp_family => $family,
		tcp_bindaddr => $bindaddr,
		tcp_host => $addr,
		tcp_port => $port
	) or $self->error("can't do_client"), return undef;

	$self->{ftp_data} = $data;
	1;
}

# end of Fan::FTP::pasv
1;
