# NOTE: Derived from ../blib/lib/Fan/Farm.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan::Farm;

#line 190 "../blib/lib/Fan/Farm.pm (autosplit into ../blib/lib/auto/Fan/Farm/d_add.al)"
;#
;# farm_add
;# add a file (Attrib object) to updater
;#
sub d_add ($$) {
	my $p = shift;
	my $fh_index = $p->{pim_index_handle};
	my $fh_step = $p->{pim_step_handle};

	# check file handle first.
	unless (defined($fh_index)) {
		carp("Farm::add: has no file handle");
		return undef;
	}

	my $y = shift; # Attribute.
	my $t = $y->type; # Abbrev for type of $y.
	my $f = $y->flag; # Abbrev for flag of $y.

	# At first, check the depth of the current tree.
	if ($t eq 'D') {
		warn("Farm::add: down to \"".$y->name."\"\n") if $LOG > 6;
		$p->{pim_depth}++;
	} elsif ($t eq 'U') {
		warn("Farm::add: up to \"..\"\n") if $LOG > 6;
		$p->{pim_depth}--;
	} else {
		warn("Farm::add: checking ".$y->name." (type=$t)...\n")
			if $LOG > 6;
	}

	# Check type/flag for given attribute.
	if ($t eq '.') {
		return $p->d_end; # terminator will be printed.
	}

	# check if we have any modification.
	if ($f ne '') {
		$p->{pim_modified} = 1;
	}

	# step mode ?
	if (!defined($fh_step)) {
		; # no step mode
	} elsif ($t eq 'D' && $y->name eq '.') {
		print $fh_step $y->to_line."\n";
	} elsif ($f eq '') {
		if ($t eq 'D') {
			push(@{$p->{pim_stack}}, $y);
		} elsif ($t eq 'U') {
			if (@{$p->{pim_stack}}) {
				pop(@{$p->{pim_stack}});
			} else {
				print $fh_step "U\n";
			}
		}
	} else {
		while (@{$p->{pim_stack}}) {
			my $a = shift(@{$p->{pim_stack}});
			print $fh_step $a->to_line."\n";
		}
		print $fh_step $y->to_line."\n";
	}

	# index mode
	if ($f ne '-') { # ignore removed files.
		$y->flag(''); # clear flag
		print $fh_index $y->to_line."\n";
		$y->flag($f); # restore.
	}

	# success
	1;
}

# end of Fan::Farm::d_add
1;
