# NOTE: Derived from ../blib/lib/Fan/Farm.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan::Farm;

#line 265 "../blib/lib/Fan/Farm.pm (autosplit into ../blib/lib/auto/Fan/Farm/d_end.al)"
;#
;# farm_end
;# terminate updater
;#
sub d_end ($) {
	my $p = shift;
	my $fh_index = $p->{pim_index_handle};
	my $fh_step = $p->{pim_step_handle};

	# Check file handle
	unless (defined($fh_index)) {
		carp("Farm::end: no file handle defined") if $LOG > 5;
		return undef;
	}

	# Check depth of working tree.
	if ($p->{pim_depth} < 1) {
		carp("Farm::end: ouch! pim_depth is too small") if $LOG > 4;
		close($fh_index); # We must close output file.
		delete($p->{pim_index_handle});
		unlink($p->{pim_index_tmp});
		warn("Farm::end: $p->{pim_index_tmp} unlinked.\n")
			if $LOG > 5;
		if (defined($fh_step)) {
			close($fh_step);
			delete($p->{pim_step_handle});
			unlink($p->{pim_step_tmp});
			warn("Farm::end: $p->{pim_step_tmp} unlinked.\n")
				if $LOG > 5;
		}
		return undef;
	}

	# Greater depth means "terminated abnormally"
	if ($p->{pim_depth} > 1) {
		carp("Farm::end: pim_depth > 1, index abort") if $LOG > 3;
		close($fh_index); # We must close output file.
		delete($p->{pim_index_handle});
		unlink($p->{pim_index_tmp});
		$fh_index = '';
		warn("Farm::end: $p->{pim_index_tmp} unlinked.\n")
			if $LOG > 5;
		if (defined($fh_step)) {
			warn("Farm::end: try to fix step files.....\n")
				if $LOG > 5;
			while ($p->{pim_depth} > 1) {
				if (@{$p->{pim_stack}}) {
					pop(@{$p->{pim_stack}});
				} else {
					print $fh_step "U\n";
				}
				$p->{pim_depth}--;
			}
		}
	}

	# put terminator, and close output file.
	if (defined($fh_index)) {
		print $fh_index ".\n";
		close($fh_index);
		delete($p->{pim_index_handle});
		warn("Farm::end: $p->{pim_index_tmp} was closed.\n")
			if $LOG > 5;

		# modified flag
		my $mod = 1;

		# check modification if needed.
		if ($p->{pim_index_max} > 0) { # exists last one
			my $rev = $p->{pim_index_max};
			my $dir = $p->{work_directory};
			my $old = "$dir/index.$rev";
			my $new = $p->{pim_index_tmp};
			my $out = "$dir/step.$rev";
			my $tmp = "$out.tmp";

			$mod = &Fan::Scan::scan_mkdiff($tmp, $old, $new);
			if (!defined($mod)) {
				warn("Farm::end: can't generate step file"
					. ", use this index.\n")
					if $LOG >5;
				warn("Farm::end: unlink $tmp\n") if $LOG > 5;
				$mod = 1;
			} elsif ($mod == 0) { # no modification...
				warn("Farm::end: no change, $tmp removed.\n")
					if $LOG > 5;
				unlink($tmp);
			} elsif (!rename($tmp, $out)) {
				carp("Farm::end: rename $tmp -> $out: $!");
				unlink($tmp);
			}
		}

		# check index modification...
		if ($mod == 0) {
			unlink($p->{pim_index_tmp});
			warn("Farm::end: no change"
				. ", $p->{pim_index_tmp} removed.\n")
				if $LOG > 5;
		} elsif (rename($p->{pim_index_tmp}, $p->{pim_index})) {
			warn("Farm::end: rename to $p->{pim_index}: o.k.\n")
				if $LOG > 5;
		} else {
			carp("Farm::end: rename($p->{pim_index}): $!");
		}
	}

	# step mode, skipped in this version.
	if (0 && defined($fh_step)) {
		print $fh_step ".\n";
		close($fh_step);
		delete($p->{pim_step_handle});
		warn("Farm::end: $p->{pim_step_tmp} was closed.\n")
			if $LOG > 5;
		if ($p->{pim_modified} == 0) {
			unlink($p->{pim_step_tmp});
			warn("Farm::end: no chage"
				. ", $p->{pim_step_tmp} removed.\n")
				if $LOG > 5;
		} elsif (rename($p->{pim_step_tmp}, $p->{pim_step})) {
			warn("Farm::end: rename to $p->{pim_step}: o.k.\n")
				if $LOG > 5;
		} else {
			carp("Farm::end: rename($p->{pim_step}): $!");
		}
	}

	# success, but really?
	1;
}

# end of Fan::Farm::d_end
1;
