# NOTE: Derived from ../blib/lib/Fan/Farm.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan::Farm;

#line 670 "../blib/lib/Fan/Farm.pm (autosplit into ../blib/lib/auto/Fan/Farm/genindex.al)"
;# Master mode:
;# Generate local index of the index directory.
;#
;# Usage:
;#	$p->genindex;
;#
sub genindex ($) {
	my $p = shift;
	my $dir = $p->{work_directory};
	my $scan = Fan::Scan->new(
		scan_type => 'LOCAL',
		scan_dir => $dir
	);
	unless (ref($scan)) {
		carp("genindex: can't create Scan object");
		return undef;
	}
	unless ($scan->add_filter(\&farm_filter)) {
		carp("genindex: can't add filter");
		return undef;
	}

	my $local_index = "$dir/index.local";
	my $tmp_index = "$local_index.tmp";
	local *TEMP;

	unless (open(TEMP, ">$tmp_index")) {
		carp("genindex: open($tmp_index): $!");
		return undef;
	}
	warn("genindex: open $tmp_index: o.k.\n") if $LOG > 5;

	my $y;
	while (defined($y = $scan->get)) {
		$y->fill_checksum;
		print TEMP $y->to_line."\n";
	}
	close(TEMP);

	unless(rename($tmp_index, $local_index)) {
		carp("genindex: rename($local_index): $!");
		unlink($tmp_index);
		warn("genindex: rename failed, unlink $tmp_index...\n")
			if $LOG > 5;
		return undef;
	}
	warn("genindex: rename to $local_index: o.k.\n");
	1;
}

# end of Fan::Farm::genindex
1;
