# NOTE: Derived from ../blib/lib/Fan/Farm.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan::Farm;

#line 966 "../blib/lib/Fan/Farm.pm (autosplit into ../blib/lib/auto/Fan/Farm/getrev.al)"
;# Get revision number for this package.
;# A file "step.i" is a diff file between "index.i" and
;# "index.(i+1)", that is, we can generate "index.12"
;# from "index.11" and "step.11".
;#
;# If this routine returns success code (== 1), you can
;# always access to $p->{pim_index_new};
;#
sub getrev ($) {
	my $p = shift;
	my $dir = $p->{work_directory};

	# Clear old revision numbers.
	delete($p->{pim_index_max});
	delete($p->{pim_index_min});
	delete($p->{pim_index_new});
	delete($p->{pim_step_max});
	delete($p->{pim_step_min});

	# try to open directory...
	local *DIR;
	unless (opendir(DIR, $dir)) {
		carp("getrev: opendir($dir): $!") if $LOG > 4;
		return undef;
	}

	# local variables to search revisions.
	my %steps = ();
	my %indexes = ();
	my $e;

	# read directory entries, and search `index.n'.
	while (defined($e = readdir(DIR))) {
		if ($e =~ /^step\.(\d+)(\.Z|\.gz)?$/) {
			$steps{$1 + 0}++;
		} elsif ($e =~ /^index\.(\d+)(\.Z|\.gz)?$/) {
			$indexes{$1 + 0}++;
		} else {
			; # simply ignored.
		}
	}
	closedir(DIR);

	# sort steps in reverse order...
	my @steps = sort { $b <=> $a } keys %steps;
	my @indexes = sort { $b <=> $a } keys %indexes;

	# Maximum / minimum index of step files.
	my $max_s = 0;
	my $min_s = 0;

	# Check the chain of step files.
	# Search largest continuous block.
	if (@steps) {
		$min_s = $max_s = shift(@steps);
		while (@steps) {
			$min_s - 1 == shift(@steps) || last;
			$min_s--;
		}
	}

	# Indexes for index files.
	my $max_i = 0;
	my $min_i = 0;

	# Check the chain of step files.
	# Search largest continuous block.
	if (@indexes) {
		$min_i = $max_i = shift(@indexes);
		while (@indexes) {
			$min_i - 1 == shift(@indexes) || last;
			$min_i--;
		}
	}

	# Validation
	if ($max_i == 0 && $max_s == 0) { # nothing found.
		$p->{pim_index_new} = 1;
	} elsif ($max_i < $min_s) { # unexpected case...
		$p->{pim_index_new} = $max_s + 2; # skip one.
	} elsif ($max_s == 0 || $min_i > $max_s + 1) { # step has no meaning
		$p->{pim_index_max} = $max_i; # we have...
		$p->{pim_index_min} = $min_i; # we have...
		$p->{pim_index_new} = $max_i + 1; # we will...
	} else { # seems good.
		$p->{pim_step_max} = $max_s; # we have...
		$p->{pim_step_min} = $min_s; # we have...
		$p->{pim_index_max} = $max_i; # we have...
		$p->{pim_index_min} = $min_i; # we have...
		if ($max_i > $max_s) { # $max_i is maximum.
			$p->{pim_index_new} = $max_i + 1; # we will...
		} else { # we can generate ($max_s + 1).
			$p->{pim_index_new} = $max_s + 2; # we will...
		}
	}

	# return success code.
	1;
}

;# end of Fan::Farm module
1;
# end of Fan::Farm::getrev
