# NOTE: Derived from ../blib/lib/Fan/Farm.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan::Farm;

#line 83 "../blib/lib/Fan/Farm.pm (autosplit into ../blib/lib/auto/Fan/Farm/new.al)"
;#
;# Creating FTP Archive Revision Managemer object.
;#
;# Usage: THIS::CLASS->new(directory_name);
;#
;# where directory_name is the directory who contains index
;# or step files.
;#
;# Index files are named as: index.1, index.2, ...
;# And step files: step.1, step.2, ...
;# step.n contains all differences between index.n and
;# index.(n+1), that is, we can generate index.(n+1) if we
;# have index.n and step.n.
;#
;# There may be also local index file, named `index.local'
;# which contains index of this work directory itself.
;#
sub new ($$) {
	my $this = shift;
	my $class = ref($this) || $this;
	my $dir = shift;

	# Check directory definition.
	if ($dir eq '') {
		carp("Fan::Farm directory not defined") if $LOG > 5;
		return undef;
	}

	# Check directory existence.
	if (! -d $dir) {
		carp("Fan::Farm no directory: $dir") if $LOG > 4;
		return undef;
	}

	# Try bless this object before we lock this directory.
	my $p = bless { work_directory => $dir }, $class;
	ref($p) || croak("Fan::Farm can't bless object");
	carp("Fan::Farm CREATING $p") if $LOG > 5;

	# Add the lock file to the hash of temporary files.
	my $lock = "$dir/.LOCK";
	$p->{tempfiles}->{$lock}++;

	# Try to lock directory.
	unless (plock($lock, 30)) {
		carp("Fan::Farm can't lock directory: $dir") if $LOG > 4;
		return undef;
	}

	# Try to get revision.
	unless ($p->getrev) {
		carp("Fan::Farm can't get revision") if $LOG > 4;
		return undef;
	}

	# Return myself.
	$p;
}

# end of Fan::Farm::new
1;
