# NOTE: Derived from ../blib/lib/Fan/Farm.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan::Farm;

#line 722 "../blib/lib/Fan/Farm.pm (autosplit into ../blib/lib/auto/Fan/Farm/synch.al)"
;# Slave mode:
;# Synchronize index directory to the master.
;#
;# Usage:
;#	$p->synch('/ftp/db/foo/index.local', $ftp);
;#	where $ftp supports $ftp->get(remote-file, local-file), and
;#	'/db/foo/index.local' is the local-index filename in localhost.
;#
sub synch ($$$$) {
	my $p = shift; # myself
	my $net = shift; # must support $net->get(remote, local).
	my $pre = shift; # prefix of remote files.
	my $start = shift; # file name we will start from.
	my $dir = $p->{work_directory};

	# check local file.
	unless (-f $start) {
		carp("synch: file $start not found");
		return undef;
	}

	#
	warn("synch: local file $start: o.k.\n") if $LOG > 5;

	# scanner
	my $scan = Fan::Scan->new(
		scan_type => 'INDEX',
		scan_index => $start,
	);
	unless (ref($scan)) {
		carp("synch: can't create index scanner");
		return undef;
	}

	# add filter
	unless ($scan->add_filter(\&farm_filter)) {
		carp("synch: can't add filter(index)");
		return undef;
	}

	# local side scanner...
	my $ours = Fan::Scan->new(
		scan_type => 'LOCAL',
		scan_dir => $p->{work_directory}
	);
	unless (ref($ours)) {
		carp("synch: can't create local scanner");
		return undef;
	}

	# add filter
	unless ($ours->add_filter(\&farm_filter)) {
		carp("synch: can't add filter(local)");
		return undef;
	}

	# parsing...
	# this is very simple mirror - only check size and checksum.
	my $max_y = undef;
	my $max_i = 0;
	my $a;
	my $b;
	while (($a, $b) = $ours->getcmp($scan)) {
		my $z;
		my $t;
		my $flag = 0;

		if (!defined($a) && !defined($b)) {
			confess("synch: UNEXPECTED CASE");
		} elsif (!defined($a)) {
			$z = $b;
			$t = $z->type;
			$flag++;
#warn("synch: local does not have $t $z->{y_name}.\n");
		} elsif (!defined($b)) {
			$z = $a;
			$t = $z->type;
			$flag--;
#warn("synch: remote does not have $t $z->{y_name}.\n");
		} else {
			$z = $b;
			$t = $z->type;

			if ($t eq '.') {
				;
			} elsif ($a->type ne $t) {
				$flag++;
#warn("synch: type mismatch $t $z->{y_name}.\n");
			} elsif ($t eq 'D') {
				;
			} elsif ($t eq 'U') {
				;
			} elsif ($t eq 'L') {
				$flag++ if $a->linkto ne $b->linkto;
#warn("synch: linkto mismatch $t $z->{y_name}.\n");
			} elsif ($t ne 'F') {
				carp("synch: UNKNOWN TYPE $t");
				return undef;
			} elsif (!$a->fill_checksum) {
				carp("synch: can't get checksum of "
					. $a->realpath);
				return undef;
			} elsif ($a->size != $b->size) {
				$flag++;
#warn("synch: size mismatch $t $z->{y_name}.\n");
			} elsif ($b->checksum eq '') {
				carp("synch: NO CHECKSUM for ".$b->path);
				return undef;
			} elsif ($a->checksum ne $b->checksum) {
				$flag++;
#warn("synch: checksum mismatch $t $z->{y_name}.\n");
			} else {
				;
			}
		}

		# check end.
		if ($t eq '.') {
			last; # done
		}

		# abbrev for path name
		my $path = "$dir/".$z->path;

		# check index file before $flag check.
		if ($t eq 'F' && $z->name =~ /^index\.(\d+)/) {
			($max_y, $max_i) = ($z, $1) if $max_i < $1;
			next;
		}

		# check flag. we only check modified files.
		$flag > 0 or next;

		# check types...
		if ($t eq 'D') {
			unlink($path) if -e $path;
			unless (mkdir($path, 0755)) {
				carp("synch: mkdir($path): $!");
				return undef;
			}
			warn("synch: mkdir($path, 0755): o.k.\n")
				if $LOG > 5;
		} elsif ($t eq 'U') {
			;
		} elsif ($t eq 'L') {
			unlink($path) if -e $path;
			symlink($z->linkto, $path);
			warn("synch: symlink($path): o.k.\n") if $LOG > 5;
		} elsif ($t eq 'F' && $z->name =~ /^step\./) {
			unless ($net->get($pre.'/'.$z->path, $path)) {
				carp("synch: GET($path): ".$net->error);
				next; # skip this...
			}
			chmod((defined($z->perm) ? $z->perm : 0644), $path);
			my $m = $z->mtime;
			if ($m > 0) {
				utime($m, $m, $path);
			}
			warn("synch: get $path: o.k.\n") if $LOG > 5;
		} else {
			; # what?
		}
	}

	# calculate revision numbers...
	$p->getrev || return undef;

	# try update.
	unless ($p->update) {
		warn("synch: can't update $dir, try continue...\n")
			if $LOG > 4;
		# continue...
	}

	# calculate revision numbers once more
	$p->getrev || return undef;

	# check remote side index file.
	unless (ref($max_y)) {
		carp("synch: no index file in remote");
		return undef;
	}

	# relative path name
	my $path = $max_y->path;

	# check index number...
	# same index?
	if ($max_i == $p->{pim_index_max}) {
		if ($max_y->name !~ /^index\.(\d+)$/) {
			if ($LOG > 4) {
				warn("synch: remote index is compressed.\n");
				warn("synch: skip checksum check.\n");
			}
			return 1;
		}
		# or checksum test.
		if (MD5File("$dir/$path") eq $max_y->checksum) {
			warn("synch: checksum($dir/$path) ok, very good!\n")
				if $LOG > 5;
			return 1;
		} else { # checksum error
			warn("synch: checksum error, unlink $dir/$path.\n")
				if $LOG > 5;
			unlink("$dir/$path");
		}
	} elsif ($max_i < $p->{pim_index_max}) {
		if ($LOG > 5) {
			warn("synch: local index($p->{pim_index_max}) was "
				. "greater than remote($max_i)\n");
			warn("synch: this may be good...\n");
		}
		return 1;
	}

	# remaining case is ($max_i > $p->{pim_index_max}),
	# or checksum error
	if (exists($p->{pim_index_max}) && $max_i > $p->{pim_index_max}) {
		warn("synch: remtoe has greater index($max_i)"
			." than local($p->{pim_index_max}).\n") if $LOG > 4;
	}
	if ($LOG > 4) {
		warn("synch: try to get $path...\n");
	}
	unless ($net->get("$pre/$path", "$dir/$path")) {
		carp("synch: GET($path): failed");
		return undef;
	}
	unless ($max_y->checksum eq MD5File("$dir/$path")) {
		warn("synch: CHECKSUM($path) mismatch, unlink it.\n");
		unlink("$dir/$path");
		return undef;
	}
	chmod(0644, "$dir/$path");

	my $m = $max_y->mtime;
	if ($m > 0) {
		utime($m, $m, "$dir/$path");
	}

	# success to small mirror, get revisions again.
	$p->getrev;
}

# end of Fan::Farm::synch
1;
