# NOTE: Derived from ../blib/lib/Fan/Loader.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan::Loader;

#line 250 "../blib/lib/Fan/Loader.pm (autosplit into ../blib/lib/auto/Fan/Loader/parse_file.al)"
;# Load file and set parameters.
;#
;# $p->parse_file(filename);
;#
sub parse_file ($$;$) {
	my $self = shift;
	my $file = shift;
	my $param_name = @_ ? shift : '';
	my $p = $self->search($param_name, 1);

	# DEBUG only
	ref($p) && $p->isa('Fan::Param')
		or confess("$p must be a Param object");

	# Check filename, add prefix is filename is relative path.
	if ($file !~ /^\// && $self->{loader_prefix} ne '') {
		$file = $self->{loader_prefix}.'/'.$file;
	}

	# Open file
	local *FILE;
	unless (open(FILE, $file)) {
		carp("$self: open($file) - $!") if $LOG > 4;
		return undef;
	}

	# Reading lines
	my $line = '';
	local $_;
	while (<FILE>) {

		# strip CR/LF at end.
		chomp;
		s/\r?$//;

		# for cont'd lines
		if ($line ne '') {
			s/^\s+// ; # strip leading spaces
			$_ = $line.$_; # concat to saved line
		}
		$line = $_, next if s/\\$//; # cont'd line

		# found one line.
		$line = ''; # clear

		# trim leading/trailing spaces, and skip comment lines.
		s/^\s+//; s/\s+$//;
		next if /^$/ || /^#/;

		# try to parse, and check result
		my $x = $self->parse_line($_, $p);
		if (!defined($x)) {
			croak("$file($.): error was detected");
		} elsif ($x eq '') { # good.
			;
		} else {
			$p = $self->search($x, 1);
			# DEBUG only
			ref($p) && $p->isa('Fan::Param')
				or confess("$p must be a Param object");
		}
	}

	# we may be able to comment out the next line.
	close(FILE);

	# Returns # of ($key, $val) pairs we changed.
	1;
}

# end of Fan::Loader::parse_file
1;
