# NOTE: Derived from ../blib/lib/Fan/Loader.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan::Loader;

#line 125 "../blib/lib/Fan/Loader.pm (autosplit into ../blib/lib/auto/Fan/Loader/parse_line.al)"
;#
;# undef name		... clear a variable `name'.
;# name			... set the value of `name' to 1.
;# name = value		... set the value of `name' to `value'.
;# name += value	... add \n + `value' to `name'.
;#
;# 1 will be returned on success.
;# when name has special meaning,... what shall we do?
;#
sub parse_line ($$;$) {
	my $self = shift;
	my $nest = $self->{loader_nest}; # hash ref.
	local $_ = shift; # an input line.
	my $param = @_ ? shift : ''; # Param object or Param name.
	my $p;

	# check param...
	if (ref($param) && $param->isa('Fan::Param')) {
		$p= $param;
	} else {
		ref($p= $self->search($param, 1)) && $p->isa('Fan::Param')
			or confess("Can't get a Param object for $param");
	}

	# Trim leading/trailing spaces.
	s/^\s+//; s/\s+$//;

	# Skip comment or null lines.
	return 0 if /^$/ || /^#/;

	# Set default value of the result.
	my($key, $val, $todo);

	# Parse this line.
	if (/^$/ || /^#/) {		# skip comment lines.
		return '';
	} elsif (/^delete\s+/) {	# delete variable.
		($key, $val, $todo) = ($', undef, 'delete');
	} elsif (/^undef\s+/) {		# set undef... TO BE FIXED.
		($key, $val, $todo) = ($', '', 'setval');
	} elsif (/\s*\+=\s*/) {		# add value.
		($key, $val, $todo) = ($`, $', 'addval');
	} elsif (/\s*=\s*/) {		# set value.
		($key, $val, $todo) = ($`, $', 'setval');
	} else {			# set to 1.
		($key, $val, $todo) = ($_, 1, 'setval');
	}

	# Convert `-' to `_'.
	$key =~ y/-/_/;
#warn("loader: key=$key, val=$val, todo=$todo\n");

	# Check special action.
	if (ref($nest) eq 'HASH' && exists($nest->{$key})) {
		my $s = $nest->{$key}; # make a copy...
		my $result;

		if ($s =~ s/^!//) {
			local $_ = $val;
			$result = eval $s;
			croak("loader: ".$@) if $@;
		} else {
			($result = $s) =~ s/\$_/$val/g;
		}
		if (!defined($result)) {
			croak("loader: wrong usage of $key");
		}
		if ($result eq '') {
			croak("loader: empty name found");
		}
		return $result;
	}

	# To check errors.
	my $err = 0;

	# Do real action.
	if ($todo eq '') {
		;
	} elsif ($todo eq 'delete') {
		$err++ if !defined($p->delete($key));
	} elsif ($todo eq 'addval') {
		$err++ if !defined($p->addval($key, $val));
	} elsif ($todo eq 'setval') {
		$err++ if !defined($p->setval($key, $val));
	} else { # what? this can't be happen.
		confess("loader: unexpected todo");
	}

	# Check the result.
	if ($err) {
		croak("loader: \"$key\" unrecognized parameter");
	}

	# Result is an empty string for normal cases.
	'';
}

# end of Fan::Loader::parse_line
1;
