# NOTE: Derived from ../blib/lib/Fan/Loader.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan::Loader;

#line 217 "../blib/lib/Fan/Loader.pm (autosplit into ../blib/lib/auto/Fan/Loader/parse_option.al)"
;#
;# $p->parse_option(\@ARRAY);
;#
sub parse_option ($\@;$) {
	my $self = shift; # loader
	my $array = shift; # reference to ARRAY
	my $param_name = @_ ? shift : '';
	my $p = $self->search($param_name, 1);

	# DEBUG only
	ref($p) && $p->isa('Fan::Param')
		or confess("$p must be a Param object");

	# Array format is "--tag=value".
	while (@{$array} && ${$array}[$[] =~ s/^--//) {
		my $x = $self->parse_line(shift(@{$array}), $p);
		if (!defined($x)) {
			croak("loader: error found in parse_option");
		} elsif ($x eq '') { # good.
			;
		} else {
			$p = $self->search($x, 1);
			# DEBUG only
			ref($p) && $p->isa('Fan::Param')
				or confess("$p must be a Param object");
		}
	}

	# This routine returns # of (key, val) pairs we changed.
	1;
}

# end of Fan::Loader::parse_option
1;
