# NOTE: Derived from ../blib/lib/Fan/Loader.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan::Loader;

#line 76 "../blib/lib/Fan/Loader.pm (autosplit into ../blib/lib/auto/Fan/Loader/search.al)"
;#
;# $loader->search($package_name [, $create]);
;#
sub search ($;$$) {
	my $self = shift;
	my $name = shift;
	my $genflag = shift;

	$name = $self->{loader_current} if $name eq '';
	$name ne '' or confess("Empty name was detected");

	# Is there a database for given name?
	my $p = $self->{loader_db}->{$name};

	# Check value and create a new one if needed.
	if (!ref($p)) { # $p->isa('Fan::Param') must also be true.
		unless ($genflag) {
#warn("search: $name not found.\n");
			# We can't generate a new one.
			return undef; # simply return FALSE.
		}
		$p = Fan::Param->new(
			param_name => $name,
			param_keys => $self->{loader_keys}
		);
		ref($p) or carp("Can't create Param object"), return undef;
		$self->{loader_db}->{$name} = $p;
#warn("search: $name = $p created.\n");
	}

	# DEBUG only
	ref($p) && $p->isa('Fan::Param')
		or confess("$p must be a Param object");

	# Register this object as `current' param.
	$self->{loader_current} = $name;

#warn("search: $name = $p found.\n");

	# return Param object.
	$p;
}

# end of Fan::Loader::search
1;
