# NOTE: Derived from ../blib/lib/Fan/Param.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan::Param;

#line 233 "../blib/lib/Fan/Param.pm (autosplit into ../blib/lib/auto/Fan/Param/try_check.al)"
;#
;#
sub try_check ($$;$) {
	my $p = shift;
	my $key = shift;
	my $h = $p->{param_keys}; # hash for keys
	local $_ = 1; # default return value.

	# Validation of the given key.
	if ($key =~ /^param_/ || (ref($h) eq 'HASH' && !exists($h->{$key}))) {
#		carp("$p: key=$key invalid key") if $LOG > 4;
		confess("$p: key=$key invalid key") if $LOG > 4;
		$p->{param_error}++;
		return undef;
	}

	# Validation of the given value, if exists.
	if (@_ && ref($h) eq 'HASH' && exists($h->{$key})) {
		my $val = $h->{$key};
		my $x = shift; # backup
		$_ = $x;

		# copy from default wants tables.
		if (!ref($val) && defined($wants{$val})) {
			$val = $wants{$val};
		}

		# check value types
		if ($_ eq '') {
			; # null string is o.k.
		} elsif ($val eq '') {
			; # o.k.
		} elsif (ref($val) eq 'CODE') {
			$_ = &{$val}($_);
		} elsif (defined(eval($val))) {
			; # good.
		} else {
			carp $@ if $@ && $LOG > 3; # evaluation error...
			undef $_;
		}
		if (!defined($_)) {
			croak("Param ($key, $x) invalid value") if $LOG > 4;
			$p->{param_error}++;
			return undef;
		}
	}

	# Result is the converted value.
	$_;
}

# end of Fan::Param::try_check
1;
