# NOTE: Derived from ../blib/lib/Fan/Scan.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan::Scan;

#line 615 "../blib/lib/Fan/Scan.pm (autosplit into ../blib/lib/auto/Fan/Scan/get_misc.al)"
;#
;# Scan with directory structure.
;# We should get directory entries per directory, sort them,
;# and hold until they will be used. A special reference of
;# $self->{magic_array} is used to hold directory entires.
;#
sub get_misc ($) {
	my $self = shift;
	my $y;

	# Try to get the current working directory...
	my $dir;
	if (!defined($dir = $self->where)) {
		$self->start;
		$y = $self->{scan_type} eq 'LOCAL'
		   ? Fan::Attrib->new(attr_path => "$self->{scan_dir}/.")
		   : Fan::Attrib->new(y_type => 'D', y_name => '.');
		if (defined($y)) {
			$y->path('.');
			$y->flag('!') unless $self->perform_filter($y);
		} else {
			carp("Attrib: Can't create object");
		}
		return $y;
	}

	# Delete skipped directories.
	my $cur = $dir;
	my $cur_n = ($cur =~ y|/|\001|);
	my $d;
	for $d (keys %{$self->{magic_array}}) {
		my $tmp = $d;
		my $tmp_n = ($tmp =~ y|/|\001|);
		if ($tmp_n >= $cur_n && $tmp lt $cur) {
			warn("Scan: ($d lt $dir) is true... skipped.\n")
				if $LOG > 5;
			delete($self->{magic_array}->{$d});
		}
	}

	# Check magic_array first.
	my $p = $self->{magic_array}->{$dir};

	# Try to get magic array for this directory
	if (!defined($p)) {
		$p = $self->{scan_type} eq 'LOCAL' ? $self->dir_local($dir)
		   : $self->{scan_type} eq 'LSLR'  ? $self->dir_lslR($dir)
		   : $self->{scan_type} eq 'FTP'   ? $self->dir_ftp($dir)
		   : undef;
		unless (defined($p)) {
			carp("get_misc: can't get array");
			return undef;
		}
	}

	# Now, ($p == $self->{magic_array}->{$dir}) is true.
	if (defined($y = shift(@{$p}))) { # something remains
		$y->path($dir.'/'.$y->name);
		if ($y->type eq 'D') {
			$self->down($y->name);
		}
		unless ($self->perform_filter($y)) {
			$y->flag('!');
			if ($y->type eq 'D') { # setup dummy array
				$self->{magic_array}->{$self->where} = [];
			}
		}
	} else { # or terminate this directory
		delete($self->{magic_array}->{$dir}); # clean
		if ($dir eq '.') {
			$self->end;
			$y = Fan::Attrib->new(y_type => '.');
		} else {
			my $tail = $dir =~ m|([^/]+)$| ? $1 : '.';
			$self->up;
			$y = Fan::Attrib->new(
				y_type => 'U',
				y_name => $tail,
				y_path => $dir );
		}
		if (defined($y)) {
			$y->flag('!') unless $self->perform_filter($y);
		} else {
			confess("Attrib: Can't create object")
		}
	}

	# return Attrib object.
	$y;
}

# end of Fan::Scan::get_misc
1;
