# NOTE: Derived from ../blib/lib/Fan/Scan.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan::Scan;

#line 965 "../blib/lib/Fan/Scan.pm (autosplit into ../blib/lib/auto/Fan/Scan/guess.al)"
;# guessing..., return the Scan object.
;#
sub guess ($$) {
	my $this = shift;
	my $foo = shift;

	# if we already have scanner, return it.
	return $foo if ref($foo) && $foo->isa('Fan::Scan');

	# directory?
	if (-d $foo) {
		return $this->new(scan_type => 'LOCAL', scan_dir => $foo);
	}

	# regular file? if so, it must be an index file.
	if (-f $foo) {
		return $this->new(scan_type => 'INDEX', scan_index => $foo);
	}

	# file glob?
	if (ref($foo) eq 'GLOB') {
		return $this->new(scan_type => 'INDEX', scan_index => $foo);
	}

	# file handle?
	if (defined(fileno($foo))) {
		return $this->new(scan_type => 'INDEX', scan_index => \*{$foo});
	}

	# what is this?
	undef;
}

# end of Fan::Scan::guess
1;
