# NOTE: Derived from ../blib/lib/Fan/Scan.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan::Scan;

#line 118 "../blib/lib/Fan/Scan.pm (autosplit into ../blib/lib/auto/Fan/Scan/new.al)"
;#
;# search a directory information for the specified directory.
;# usage:
;#	scan_type :
;#		LOCAL ... scan_dir
;#		INDEX ... scan_index
;#		LSLR  ... scan_lslR
;#		FTP   ... scan_ftp, scan_dir
;#		HTTP  ... scan_ftp, scan_dir
;#	$scan = Fan::Scan->new(
;#		scan_type => LSLR,
;#		scan_lslR => "ls-lR.gz" );
;#
sub new ($%) {
	my $this = shift;
	my $class = ref($this) || $this;
	my %params = @_;
	my $self = {};
	bless $self, $class;

	# copy any scan parameter.
	for my $tag (keys %params) {
		$self->{$tag} = $params{$tag} if $tag =~ /^scan_/;
	}

	# Find out scan type.
	my $t = $self->{scan_type};

	# Check types...
	if (!defined($t)) { # not found.
		carp("No scan_type defined"), return undef;
	} elsif ($t eq 'LOCAL') { # scan local directory
		$self->{scan_dir} ne '' && -d $self->{scan_dir}
			or carp("No local directory"), return undef;
	} elsif ($t eq 'FTP') {
		ref($self->{scan_ftp}) # must be some module
			or carp("No scan_ftp"), return undef;
		$self->{scan_dir} ne ''
			or carp("No scan_dir"), return undef;
	} elsif ($t eq 'INDEX') {
		$self->open($self->{scan_index})
			or carp("open(scan_index): $!"), return undef;
	} elsif ($t eq 'LSLR') {
		$self->open($self->{scan_lslR})
			or carp("open(scan_lslR): $!"), return undef;
	} else {
		carp("Scan does not know method"), return undef;
	}

	# cleanup
	delete($self->{endoffile});
	delete($self->{founderror});
	delete($self->{subst});
	delete($self->{hold});
	$self->{magic_array} = {};
	$self->{cur_info} = {};
	$self->{dirs} = [];
	$self->{lslR_curdir} = '.';
	$self->{scan_filter} = [];

	# Log message.
	carp("Scan CREATING $self") if $LOG > 5;

	# Return myself
	$self;
}

# end of Fan::Scan::new
1;
