# NOTE: Derived from ../blib/lib/Fan/Scan.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan::Scan;

#line 271 "../blib/lib/Fan/Scan.pm (autosplit into ../blib/lib/auto/Fan/Scan/open.al)"
;#
;# Scan::open
;# Open a file, which may be .gz or .Z compressed file.
;#
sub open ($$) {
	my $self = shift;
	my $file = shift;

	# close first
	$self->close;

	# check filter
	if (ref($file) ne 'GLOB') {
		my $a = $file =~ /\.gz$/ ? "$path_gzip -cd $file|" :
			$file =~ /\.Z$/ ? "$path_compress -cd $file|" :
			-f $file ? $file :
			-f "$file.gz" ? "$path_gzip -cd $file.gz|" :
			-f "$file.Z" ? "$path_compress -cd $file.Z|" :
			$file;

		# local file handle.
		local *FILE;

		# Now, try to open.
		unless (CORE::open(FILE, $a)) {
			carp("CORE::open($a): $!");
			return undef;
		}

# warn("open[".fileno(*FILE)."] $a: o.k.\n");

		# mark as OPENED file.
		$self->{needclose}++;

		# now store to $file.
		$file = *FILE;
	}

	# Register the file handle
	$self->{handle} = $file;

	# Increment # of objects
	$n_object++;

	# Success
	1;
}

# end of Fan::Scan::open
1;
