# NOTE: Derived from ../blib/lib/Fan/Scan.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan::Scan;

#line 1046 "../blib/lib/Fan/Scan.pm (autosplit into ../blib/lib/auto/Fan/Scan/scan_mklist.al)"
;#
;# scan_mklist(output, directory);
;#
;# Return codes:
;#	undef	error was detected.
;#	1	success, the newest list was created.
;#
sub scan_mklist ($$) {
	my $file = shift;
	my $dir = shift;

	my $op = &fileglob($file, 'w');
	my $no = fileno($op);

	if (!defined($no)) {
		carp("scan_mklist: fileglog($file): failure.") if $LOG > 5;
		return undef;
	}

	# debug log
	if (ref($op) eq 'GLOB') { # normal file.
		warn("scan_mklist: use[$no] $file: o.k.\n") if $LOG > 5;
	} else {
		warn("scan_mklist: open[$no] $file: o.k.\n") if $LOG > 5;
	}

	# Try to open local directory tree.
	my $scan = Fan::Scan->guess($dir);

	unless (ref($scan) && $scan->isa('Fan::Scan')) {
		carp("scan_mklist: can't create scanner($dir)");
		return undef;
	}

	# generate lists.
	my $a;
	while (defined($a = $scan->get)) {
		$a->fill_checksum; # checksum is optional.
		print $op $a->to_line."\n";
	}

	# close if needed.
	if (ref($op) eq 'GLOB') {
		warn("scan_mklist: unuse[$no] $file...\n") if $LOG > 5;
	} else {
		warn("scan_mklist: close[$no] $file...\n") if $LOG > 5;
	}

	# this causes the target file be closed automatically.
	undef $op;

	# success.
	1;
}

# end of Fan::Scan::scan_mklist
1;
