# NOTE: Derived from ../blib/lib/Fan/Scan.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan::Scan;

#line 1201 "../blib/lib/Fan/Scan.pm (autosplit into ../blib/lib/auto/Fan/Scan/scan_update.al)"
;#
;# scan_update(output, base, diff [, diff...]);
;#
;# Return codes:
;#	undef	error was detected.
;#	1	success, the newest list was created.
;#
sub scan_update ($$@) {
	my $file = shift;
	my $base = shift;
	my @diff = @_;

	my $op = &fileglob($file, 'w');
	my $no = fileno($op);

	if (!defined($no)) {
		carp("scan_update: fileglog($file): failure.") if $LOG > 5;
		return undef;
	}

	# debug log
	if (ref($op) eq 'GLOB') { # normal file.
		warn("scan_update: use[$no] $file: o.k.\n") if $LOG > 5;
	} else {
		warn("scan_update: open[$no] $file: o.k.\n") if $LOG > 5;
	}

	# Open the index who has maximum number.
	my $basescan = Fan::Scan->guess($base);

	unless(ref($basescan) && $basescan->isa('Fan::Scan')) {
		carp("update: can't create scanner($base)");
		return undef;
	}
	warn("scan_update: base $base: o.k.\n") if $LOG > 5;

	# Initialize array.
	my @array = ();

	# Open step files...
	for my $file (@diff) {
		my $q = Fan::Scan->guess($file);

		unless(ref($q) && $q->isa('Fan::Scan')) {
			carp("update: can't create scanner($file)");
			return undef;
		}
		push(@array, $q);
		warn("scan_update: add $file: o.k.\n") if $LOG > 5;
	}

	# Try merge
	my @a;
	while (@a = $basescan->getcmp(@array)) {
		my $a;
		my $x = undef;

		while (@a) {
			my $a = shift(@a);
			$x = $a if ref($a) && $a->isa('Fan::Attrib');
		}
		if (!defined($x)) {
			confess("scan_update: UNEXPECTED CASE");
		} elsif ($x->flag ne '-') {
			$x->flag('');
			print $op $x->to_line."\n";
		}
	}

	# close if needed.
	if (ref($op) eq 'GLOB') {
		warn("scan_update: unuse[$no] $file...\n") if $LOG > 5;
	} else {
		warn("scan_update: close[$no] $file...\n") if $LOG > 5;
	}

	# this causes the target file be closed automatically.
	undef $op;

	# Success return.
	1;
}

# end of Fan::Scan::scan_update
1;
