# NOTE: Derived from ../blib/lib/Fan/TCP.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan::TCP;

#line 335 "../blib/lib/Fan/TCP.pm (autosplit into ../blib/lib/auto/Fan/TCP/putdata.al)"
;# send data to server
sub putdata ($$) {
	my $self = shift;
	my $data = shift;
	my $length = length($data);
	my $sock = $self->handle;
	my $ok = undef;

	# DEBUG only - check socket!
	defined($sock) or confess("TCP: socket is not defined");

	# try to clear current status.
	$self->clearerror || return undef;

	# if we already found end-of-file, return undef
	return undef if $self->{endoffile};

	# get a line from socket
	eval {
		local $SIG{'ALRM'} = sub { die("alarm\n") };
		alarm($self->{tcp_timeout});
		$ok = print $sock ($data);
		alarm(0);
	};

	# check result.
	if ($@) {
		if ($@ eq "alarm\n") {
			warn("putdata: TIME OUT\n") if $LOG > 5;
			$self->error("operation timed out", &FATAL);
			return undef;
		}
		croak($@); # other evaluation error
	}

	# check result
	unless ($ok) {
		my $e = $!.'';
		$self->error($e, &FATAL);
		carp("$self: print - $e");
		return undef;
	}

	# or success to send data
	if ($LOG > 6 || $self->{tcp_debug}) {
		my $fno = fileno($self->{tcp_sock});
		warn("$self [$fno] wrote $length octets.\n");
	}

	# count up sent data size
	$self->{tcp_sent_octets} += $length;

	# success, and return this line.
	1;
}

# end of Fan::TCP::putdata
1;
