# NOTE: Derived from blib/lib/Fan.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan;

#line 2088 "blib/lib/Fan.pm (autosplit into blib/lib/auto/Fan/calc_offset.al)"
;#
;# Calculate offset of server's timezone.
;# Usage:
;#	$offset = &calc_offset(time_in_gmt, time_in_local);
;#
sub calc_offset ($$) {
	my $exact = shift;
	my $wrong = shift;
	my $diff = $wrong - $exact;

	# $z is the timezone
	my $h = int((abs($diff) + 1800) / 3600);

	# check offset value
	if ($h >= 24) {
		warn("calc_offset: diff=$diff seems wrong.\n");
		return undef;
	}

	# debug log
	# my $z = ($diff < 0 ? '-' : '+').sprintf("%02d00", $h);
	# plog(6, "calc_offset: timezone seems to be $z\n");

	# result is the offset value of timezone.
	my $offset = 3600 * $h;
	$offset = - $offset if $diff < 0;
	$offset;
}

# end of Fan::calc_offset
1;
