# NOTE: Derived from blib/lib/Fan.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan;

#line 2408 "blib/lib/Fan.pm (autosplit into blib/lib/auto/Fan/changer_filter.al)"
;#
sub changer_filter {
	my $y = shift; # Fan::Attrib object.
	my $p = shift; # Argument == Fan object.
	my $t = $y->type;

	# change file mode
	if ($t eq 'D' || $t eq 'U') {
		my $mode = $p->override_directory_mode;
		if ($p->override_directory_mode) {
			$mode = oct($p->override_directory_mode);
		} elsif (defined($y->perm)) {
			$mode = $y->perm; # not in octal
		} elsif ($p->default_directory_mode) {
			$mode = oct($p->default_directory_mode);
		} else {
			$mode = 0755;
		}
		$y->perm($mode);
	} elsif ($t eq 'F') {
		my $mode;
		if ($p->override_file_mode) {
			$mode = oct($p->override_file_mode);
		} elsif (defined($y->perm)) {
			$mode = $y->perm; # not octal
		} elsif ($p->default_file_mode) {
			$mode = oct($p->default_file_mode);
		} else {
			$mode = 0644;
		}
		$y->perm($mode);
	}

	# only super user can change owner
	if ($< == 0 && ($t eq 'D' || $t eq 'U' || $t eq 'F')) {
		my $uid;
		my $gid;

		if (defined($uid = get_uid($p->override_file_uid))) {
			; # o.k.
		} elsif (defined($uid = get_uid($y->owner))) {
			; # o.k.
		} elsif (defined($uid = get_uid($p->default_file_uid))) {
			; # o.k.
		} else {
			$uid = 0;
		}
		$y->owner($uid);

		if (defined($gid = get_gid($p->override_file_gid))) {
			; # o.k.
		} elsif (defined($gid = get_gid($y->group))) {
			; # o.k.
		} elsif (defined($gid = get_gid($p->default_file_gid))) {
			; # o.k.
		} else {
			$gid = (split(/\s+/, $)))[0];
		}
		$y->group($gid);
	}

	# and we always return success
	1;
}

# end of Fan::changer_filter
1;
