# NOTE: Derived from blib/lib/Fan.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan;

#line 2049 "blib/lib/Fan.pm (autosplit into blib/lib/auto/Fan/date_check.al)"
;#
;# date_check returns 1 if check is o.k.
;#
sub date_check ($$) {
	my $date = shift;
	my $time = shift;

	$date =~ s/\s+/ /g || return undef; # maybe null string.

warn("date_check: $time vs [$date]\n") if $LOG > 7;

	my($sec, $min, $hour, $day, $month, $year) = gmtime($time);
	my $mon = $Fan::Cool::nameofmonth[$month];
	$month++;

	my $d;
	if ($date =~ /^\d\d-\d\d-\d\d \d\d:\d\d(AM|PM)$/i) { # DOS?
		$d = sprintf("%02d-%02d-%02d %02d:%02d%s",
		$month + 1, $day, $year, ($hour > 12 ? $hour - 12 : $hour),
		$min, ($hour > 12 ? 'PM' : 'AM'));
	} elsif ($date =~ / \d\d:\d\d:\d\d \d\d\d\d$/) { # long format
		$d = sprintf("%s %d %02d:%02d:%02d %04d", $mon, $day,
			$hour, $min, $sec, $year + 1900);
	} elsif ($date =~ / \d\d:\d\d$/) { # time
		$d = sprintf("%s %d %02d:%02d", $mon, $day, $hour, $min);
	} elsif ($date =~ / \d:\d\d$/) {
		$d = sprintf("%s %d %d:%02d", $mon, $day, $hour, $min);
	} else {
		$d = sprintf("%s %d %04d", $mon, $day, $year + 1900);
	}

	my $result = $date eq $d ? 1 : 0;
warn("date_check: [$d] vs [$date] results $result\n") if $LOG > 7;

	$result;
}

# end of Fan::date_check
1;
