# NOTE: Derived from blib/lib/Fan.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan;

#line 1418 "blib/lib/Fan.pm (autosplit into blib/lib/auto/Fan/fill_mtime.al)"
;#
sub fill_mtime ($$) {
	my $p = shift; # myself
	my $y = shift; # Attrib

	# debug log...
	warn("fill_mtime: try ".$y->path."\n") if $LOG > 6;

	# check if $y->mtime is defined.
	if (defined($y->mtime)) {
		warn("fill_mtime: already has mtime.\n") if $LOG > 6;
		return 1;
	}

	# we need ftp to get mtime.
	my $ftp = $p->via_ftp;
	unless (ref($ftp)) {
		warn("fill_mtime: no ftp session found.\n") if $LOG > 6;
		return undef;
	}

	# try to get mtime.
	my $m = $ftp->mtime($y->path);
	unless (defined($m) && $y->mtime($m)) {
		warn("fill_mtime: fail to get mtime\n") if $LOG > 6;
		return undef;
	}

	# mtime found, debug log...
	warn("fill_mtime: $m (".$y->path.").\n") if $LOG > 6;

	# can we set offset value?
	if ($y->date =~ /\d\d+:\d\d/) {
		my $off = $p->ftp_offset;
		my $off2 = $y->time0 - $y->mtime;
		if (!defined($off) || abs($off - $off2) > 600) {
			$p->adjust_offset($y->mtime, $y->time0);
		}
	}

	# result must be o.k.
	1;
}

# end of Fan::fill_mtime
1;
