# NOTE: Derived from blib/lib/Fan.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan;

#line 231 "blib/lib/Fan.pm (autosplit into blib/lib/auto/Fan/find_archive.al)"
;#
sub find_archive ($$) {
	my $this = shift; # may be class name.
	my $class = ref($this) || $this;
	my $name = shift;
	my $pack = 'PACKAGE::'.$name;

	# Search this package...
	unless ($loader->search($pack)) {
		warn("find_archive: package $pack not defined.\n");
		return undef;
	}

	# Parsers list.
	my @list = ('INIT', 'DEFAULT', $pack, 'OPTION');

	# Try to generate Archive object.
	if (defined(my $srv = $loader->get_value('ftp_server', @list))) {
		# If we have server parameter, try add it.
		if ($loader->search('SERVER::'.$srv)) {
			splice(@list, 2, 0, 'SERVER::'.$srv);
		}
	}

	# Generate a new Archive object.
	my $p = $class->new(param_name => 'RUN::'.$name);
	unless (ref($p) && $p->isa('Fan::Param')) {
		warn("find_archive: can't create Param object.\n");
		return undef;
	}

	# Merge parameters.
	for my $n (@list) {
		$p->merge($loader->search($n));
	}

	# Set verbose or debug.
	if ($p->debug || $p->verbose) {
		my $n = $p->debug ? 7 : 6;
		plog_mask("Fan=$n,Fan::Farm=$n");
		$p->ftp_stats(1);
	}

	# Set logging level if given.
	if (defined(my $mask = $p->log_mask)) {
		plog_mask($mask);
	}

	# Check it
	unless ($p->check) {
		warn("find_archive: archive check error.\n");
		return undef;
	}

	# Success.
	$p;
}

# end of Fan::find_archive
1;
