# NOTE: Derived from blib/lib/Fan.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan;

#line 2302 "blib/lib/Fan.pm (autosplit into blib/lib/auto/Fan/local_scanner.al)"
;#
sub local_scanner ($;$) {
	my $p = shift; # Fan object
	my $force_local = @_ ? shift : !$p->use_master_db;
	my $dir = $p->master_db_directory;
	my $scan = undef;

	# local index file can be used for local scanner...
	if (!$force_local && $dir ne '' && -d $dir) {
		my $farm = Fan::Farm->new($dir);
		if (defined($farm) && $farm->{pim_index_max} > 0) {
			my $index = "$dir/index.$farm->{pim_index_max}";
			$scan = Fan::Scan->new(
				scan_type => 'INDEX',
				scan_index => $index
			);
		}
	}

	# local side scanner
	if (!defined($scan)) {
		$scan = Fan::Scan->new(
			scan_type => 'LOCAL',
			scan_dir => $p->local_directory,
		);
	}

	unless (defined($scan)) {
		carp("local_scanner: can't create Scan(LOCAL)");
		return undef;
	}

	# additional filters
	my $code = $p->put_mode ? \&server_filter : \&client_filter;
	unless ($scan->add_filter($code, $p)) {
		carp("local_scanner: can't add filter");
		return undef;
	}

	# additional filters for file uid/gid, file mode
	if ($p->put_mode) {
		unless ($scan->add_filter(\&changer_filter, $p)) {
			carp("remote_scanner: can't add changer");
			return undef;
		}
	}

	# information log...
	warn("local directory = ".$p->local_directory."\n") if $LOG >= 5;

	#
	$scan;
}

# end of Fan::local_scanner
1;
