# NOTE: Derived from blib/lib/Fan.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan;

#line 665 "blib/lib/Fan.pm (autosplit into blib/lib/auto/Fan/net_init.al)"
;# Initialize network
;# FTP or HTTP(proxy)
;#
sub net_init {
	my $p = shift;
	my $package = $p->{param_name};
	my $msg = '';

	# fast return for initialized package
	return 1 if $p->{net_initialized};

	# Check package name first.
	$package =~ s/^RUN:://
		or confess("ERR $package is invalid package name");

	# do lock in put mode
	unless ($p->put_mode || $p->do_lock) {
		warn("$package: can't lock the package.\n");
		return undef;
	}

	# Check ftp-server.
	if ($p->ftp_server eq '') {
		warn("ERR($package) no FTP server defined.\n");
		return undef;
	}

	# And remote_directory.
	if ($p->remote_directory eq '') {
		warn("ERR($package) no remote_directory defined.\n");
		return undef;
	}

	# abbrevs for remote directory.
	# You can use HTTP to transfer files.
	# In this case, at least one of lslR_file, archive_index,
	# or load_remote_dirinfo must be given.
	if ($p->http_proxy) {
		use Fan::HTTP;

		my $http = Fan::HTTP->new(
			http_proto => 'ftp',
			http_server => $p->ftp_server,
			http_proxy => $p->http_proxy);
		ref($http)
			or warn("Can't create HTTP object"), return undef;
		plog(5, "using HTTP proxy for file transfer.\n");

		$msg = "server = ".$p->ftp_server;
		$msg .= " (http via ".$p->http_proxy.")";
		plog(5, $msg."\n");

		$p->setval('via_http', $http);
	} else {
		use Fan::FTP;

		my %param = (
			ftp_server => $p->ftp_server,
			ftp_user => $p->ftp_user,
			ftp_pass => $p->ftp_pass,
			ftp_directory => $p->remote_directory,
		);
		$param{ftp_gateway} = $p->ftp_gateway
			if $p->ftp_gateway ne '';
		$param{ftp_bindaddr} = $p->ftp_bindaddr
			if $p->ftp_bindaddr ne '';
		$param{ftp_login_retry} = $p->ftp_login_retry
			if $p->ftp_login_retry > 0;
		$param{ftp_login_delay} = $p->ftp_login_delay
			if $p->ftp_login_delay > 0;
		$param{ftp_port} = $p->ftp_port
			if $p->ftp_port > 0;
		$param{ftp_group} = $p->ftp_group
			if $p->ftp_group ne '';
		$param{ftp_gpass} = $p->ftp_gpass
			if $p->ftp_gpass ne '';
		$param{ftp_passive} = 1
			if $p->ftp_passive;
		$param{ftp_idle} = $p->ftp_idle
			if $p->ftp_idle > 0;
		$param{ftp_idle} = -1
			if $p->ftp_max_idle;
		$param{ftp_timeout} = $p->ftp_timeout
			if $p->ftp_timeout > 0;
		$param{tcp_debug} = 1
			if $p->ftp_debug;
		$param{ftp_stats} = 1
			if $p->ftp_stats;

		my $ftp = Fan::FTP->new(%param);
		unless (ref($ftp)) {
			warn("Can't create FTP object");
			return undef;
		}
		plog(5, "using FTP for file transfer.\n");

		# Show server name.
		$msg = "server = ".$p->ftp_server;
		$msg .= " (ftp via ".$p->ftp_gateway.")" if $p->ftp_gateway;
		plog(5, $msg."\n");

		# Show user account.
		$msg = "username = ".$p->ftp_user;
		$msg .= '/'.$p->ftp_pass
			if $p->ftp_user eq 'ftp' || $p->ftp_user eq 'anonymous';
		plog(5, $msg."\n");

# WE USE DELAYED LOGIN, THAT IS, WE WILL LOGIN WHEN FIRST COMMAND
# WILL SEND TO THE SERVER.
#		plog(5, "try login...\n");
#
#		unless ($ftp->login) {
#			warn("net_init: can't login to the server");
#			return undef;
#		}

		$p->setval('via_ftp', $ftp);
	}

	# And, some additional information.
	plog(5, "transfer type = ".($p->put_mode ? 'put' : 'get')."\n");

	# network flag
	$p->{net_initialized}++;

	# success to init network methods...
	1;
}

# end of Fan::net_init
1;
