# NOTE: Derived from blib/lib/Fan.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan;

#line 2165 "blib/lib/Fan.pm (autosplit into blib/lib/auto/Fan/remote_scanner.al)"
;#
;# generate server side scanner.
;# returning Scan object.
;#
sub remote_scanner ($;$) {
	my $p = shift; # Fan object.
	my $force_ftp = @_ ? shift : 0;
	my $scan = undef;

	# Check network initialization.
	unless ($p->net_init) {
		warn("step_synch: can't initialize network");
		return undef;
	}

	# Check index directories.
	# SHOULD WE HAVE A NEW FLAG FOR INDEX MODE?
	if (!$force_ftp && $p->local_db_directory) { # index mode
		unless ($p->step_synch) {
			carp("remote_scanner: can't synch step files");
			return undef;
		}
		$scan = Fan::Scan->new(
			scan_type => 'INDEX',
			scan_index => $p->{newest_index_file},
		);
		unless (defined($scan)) {
			carp("remote_scanner: Can't create Scan(INDEX)");
			return undef;
		}
	}

	# Try to get remote lslR file if required.
	my $file = $p->lslR_file;
	my $copy = $p->lslR_copy;
	my $lslR_mode = $file || $copy;
	if (!$force_ftp && !defined($scan) && $lslR_mode) {
		my $notrans = 0;
		my $a = undef;
		my $m = 0;

		# if we have remote lslR_file.
		if ($file ne '') {
			my $tail;
			($tail) = $file =~ m|([^/]+)$|;
			$a = Fan::Attrib->new(
				y_type => 'F',
				y_path => $file,
				y_name => $tail,
			);
			$p->fill_size($a);
			$p->fill_mtime($a);
			$m = $a->mtime;
		}

		# change to absulte if needed.
		if ($copy =~ /^[^\/]/) {
			$copy = $p->local_directory.'.'.$copy;
		}

		# check if we should transfer lslR_file or not.
		if ($copy eq '') {
			$copy = $p->temp_directory."/ls$$";
			$copy .= $& if $file =~ /\.(gz|Z)$/;
			$p->{tempfiles}->{$copy}++;
		} elsif (-f $copy) {
			my $y = Fan::Attrib->new(attr_path => $copy);
			if (!ref($a)) {
				$notrans++;
			} elsif ($a->size == $y->size && $y->mtime eq $m) {
				$notrans++; # no need to transfer...
			}
		} elsif (!ref($a)) {
			carp("remote_scanner: no remote lslR_file");
			return undef;
		}

		# notrans flags or try to retrieve server's lslR file.
		unless ($notrans || $p->get($file, $copy)) {
			carp("remote_scanner: can't get $file");
			return undef;
		}

		# try to set modified time of local copy.
		if ($m > 0) {
			utime($m, $m, $copy); # ignore result.
		}

		# now, generate scanner.
		$scan = Fan::Scan->new(
			scan_type => 'LSLR',
			scan_lslR => $copy
		);

		# check result.
		unless (defined($scan)) {
			carp("remote_scanner: can't create Scan(LSLR)");
			return undef;
		}
	}

	# try normal FTP session
	if (!defined($scan)) { # normal FTP session
		if ($p->load_remote_dirinfo) { # we can load dirinfo?
			plog(5, "load dirinfo = yes\n");
		}
		$scan = Fan::Scan->new(
			scan_type => 'FTP',
			scan_ftp => $p,	# myself
			scan_dir => $p->remote_directory,
			scan_dirinfo => $p->load_remote_dirinfo
		);
		unless (defined($scan)) {
			carp("remote_scanner: can't create Scan(FTP)");
			return undef;
		}
	}

	# additional filters
	my $code = $p->put_mode ? \&client_filter : \&server_filter;
	unless ($scan->add_filter($code, $p)) {
		carp("remote_scanner: can't add filter");
		return undef;
	}

	# additional filters for file uid/gid, file mode
	unless ($p->put_mode) {
		unless ($scan->add_filter(\&changer_filter, $p)) {
			carp("remote_scanner: can't add changer");
			return undef;
		}
	}

	# information log...
	warn("remote directory = ".$p->remote_directory."\n") if $LOG >= 5;

	# $scan is defined on success
	$scan;
}

# end of Fan::remote_scanner
1;
