# NOTE: Derived from blib/lib/Fan.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan;

#line 963 "blib/lib/Fan.pm (autosplit into blib/lib/auto/Fan/run_step_mirror.al)"
;#
;#
sub run_step_mirror {
	my $p = shift;

	unless ($p->net_init) {
		warn("step_synch: can't initialize network");
		return undef;
	}

	#
	unless ($p->step_synch) {
		carp("step_mirror: can't sync..., try full mirror");
		return undef;
	}

	# check if we have newer step files?
	unless (exists($p->{newer_step_files})) {
		warn("step_mirror: no step files to synch.\n") if $LOG > 4;
		return 1;
	}

	# check if we have newer step files?
	unless (@{$p->{newer_step_files}}) {
		warn("step_mirror: empty step file array.\n") if $LOG > 4;
		return 1;
	}

	# or we have something to mirror
	my @newer_scan = ();

	# generate scans... 
	for my $i (@{$p->{newer_step_files}}) {
		my $scan = Fan::Scan->new(
			scan_type => 'INDEX',
			scan_index => $i
		);
		unless (ref($scan)) {
			carp("step_mirror: can't create Scan for $i");
			return undef;
		}
		unless ($scan->add_filter(\&server_filter, $p)) {
			carp("step_mirror: can't add filter for $i");
			return undef;
		}
		push(@newer_scan, $scan);
	}

	#
	warn("step_mirror: starting\n") if $LOG > 5;

	my $base = shift(@newer_scan);
	my @x;
	while (@x = $base->getcmp(@newer_scan)) {
		my $x;

		# search lastest one
		for my $y (@x) {
			$x = $y if ref($y);
		}
		ref($x) or confess("UNEXPECTED CASE");

		my $f = $x->flag;
		my $t = $x->type;

		# check end-of-data
		last if $t eq '.';

		# get pathname
		my $path = $x->path;
		my $show = &Fan::Attrib::attr_encode($path);

		# check flag...
		if ($f eq '-') { # DELETE
			if ($t eq 'D') {
				; # simply ignored
			} elsif ($p->del($x)) {
				plog(5, "-$t $show: success\n");
			} else {
				plog(5, "-$t $show: failure\n");
			}
		} elsif ($f eq '+' || $f eq '') { # ADD
			my $realpath = $p->local_directory.'/'.$x->path;
			my $a = undef;
			my $m = 0;
			my $op = $p->test_mode ? 3 : 2;

			$a = Fan::Attrib->new(attr_path => $realpath)
				if $t ne 'U' && -e $realpath;
			if ($t eq 'U') {
				; # simply ignored
			} elsif ($a && defined($m = $p->besame($a, $x, $op))) {
				if ($m) {
					plog(5, "+$t $show: modified\n");
				} else {
					plog(5, "#$t $show: o.k.\n");
				}
			} elsif ($p->add($x)) {
				plog(5, "+$t $show: success\n");
			} else {
				plog(5, "+$t $show: failure\n");
			}
		} else {
			; # unknown flags...
		}
	}

	# writing lastest step file.
	unless ($p->last_seq($p->{newest_step} + 1)) {
		warn("step_mirror: can't write last seq.\n") if $LOG > 5;
		return undef;
	}

	warn("step_mirror: done.\n") if $LOG > 5;

	#
	1;
}

# end of Fan::run_step_mirror
1;
