# NOTE: Derived from blib/lib/Fan.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan;

#line 830 "blib/lib/Fan.pm (autosplit into blib/lib/auto/Fan/step_synch.al)"
;#
;#
sub step_synch {
	my $p = shift; # Fan object...

	unless ($p->net_init) {
		warn("step_synch: can't initialize network");
		return undef;
	}

	my $ldb = $p->local_db_directory;
	if ($ldb eq '') {
		carp("step_synch: no local_db_directory defined");
		return undef;
	}
	if (! -d $ldb) {
		carp("step_synch: local_db_directory is not a directory");
		return undef;
	}

	my $db = Fan::Farm->new($ldb);
	unless (ref($db)) {
		carp("step_synch: can't create Fan::Farm object");
		return undef;
	}

	my $rdb = $p->remote_db_directory;
	if ($rdb eq '') {
		if (! -f "$ldb/index.local") {
			carp("step_synch: neither remote_db_directory nor"
				. " local index found");
			return undef;
		}
		warn("step_synch: no remote_db_directory"
			. ", use local mode.\n")
			if $LOG > 5;
	} else {
		my $notrans = 0;
		my $a = Fan::Attrib->new(
			y_type => 'F',
			y_path => "$rdb/index.local",
			y_name => "index.local",
		);
		unless (ref($a)) {
			carp("step_synch: can't create Fan::Attrib object");
			return undef;
		}
		if (-f "$ldb/index.local" && ref($a)) {
warn("step_synch: $ldb/index.local found\n") if $LOG > 6;
			$b = Fan::Attrib->new(attr_path => "$ldb/index.local");
			unless (ref($b)) {
				carp("step_synch: can't create"
					. " Fan::Attrib object");
				return undef;
			}
			$p->fill_size($a);
			$p->fill_mtime($a);
			if ($a->size == $b->size && $a->mtime == $b->mtime) {
				$notrans++;
			}
		} else {
warn("step_synch: $ldb/index.local not found\n") if $LOG > 6;
		}

		if ($notrans) {
			warn("step_synch: no need to transfer index.local\n")
				if $LOG > 5;
		} elsif ($p->get("$rdb/index.local", "$ldb/index.local")) {
			warn("step_synch: got index.local: o.k.\n")
				if $LOG > 5;
		} else {
			carp("step_synch: can't retrieve index.local");
			return undef;
		}

		my $m = $a->mtime;
		utime($m, $m, "$ldb/index.local") if $m > 0;

		unless ($db->synch($p, $rdb, "$ldb/index.local")) {
			carp("step_synch: can't synchronise to remote");
			return undef;
		}

		warn("step_synch: synch o.k.\n") if $LOG > 5;
	}

	# get local revisions, again.
	unless ($db->getrev) {
		carp("step_synch: can't get revision");
		return undef;
	}

	# check latest index file
	unless ($db->{pim_index_max} > 0) {
		carp("step_synch: no index file found");
		return undef;
	}

	# get index file, and step files
	$p->{newest_index} = $db->{pim_index_max};
	$p->{newest_index_file} = "$ldb/index.$p->{newest_index}";

	# log it
	warn("step_synch: newest index is $p->{newest_index_file}.\n")
		if $LOG > 5;

	# can we get last seq?
	my $last = $p->last_seq;
	unless ($last > 0) {
		warn("step_synch: last# is not found $last.\n") if $LOG > 5;
		return 1;
	}

	# search step files
	$p->{newer_step_files} = [];
	if ($db->{pim_step_max} > $last) {
		if ($last < $db->{pim_step_min}) {
			warn("step_synch: step index is larger than mine.\n")
				if $LOG > 4;
			$last = $db->{pim_step_min};
		}
		for (my $i = $last; $i <= $db->{pim_step_max}; $i++) {
			push(@{$p->{newer_step_files}}, "$ldb/step.$i");
			warn("step_synch: add step $ldb/step.$i.\n")
				if $LOG > 5;
			$p->{newest_step} = $i;
		}
	}

	# success
	1;
}

# end of Fan::step_synch
1;
