/* GKrellM
|  Copyright (C) 1999-2001 Bill Wilson
|
|  Author:  Bill Wilson    bill@gkrellm.net
|  Latest versions might be found at:  http://gkrellm.net
|
|  This program is free software which I release under the GNU General Public
|  License. You may redistribute and/or modify this program under the terms
|  of that license as published by the Free Software Foundation; either
|  version 2 of the License, or (at your option) any later version.
|
|  This program is distributed in the hope that it will be useful,
|  but WITHOUT ANY WARRANTY; without even the implied warranty of
|  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
|  GNU General Public License for more details.
| 
|  To get a copy of the GNU General Puplic License, write to the Free Software
|  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


/* Public GKrellM function prototypes available for all monitors and plugins */

GtkWidget	*gkrellm_get_top_window(void);
gchar		*gkrellm_get_theme_path(void);
Chart		*gkrellm_chart_new0(void);
Panel		*gkrellm_panel_new0(void);
Krell		*gkrellm_krell_new0(void);
Decal		*gkrellm_decal_new0(void);
Label		*gkrellm_label_new0(void);
Style		*gkrellm_style_new0(void);
Style		*gkrellm_copy_style(Style *);
TextStyle	*gkrellm_textstyle_new0(void);
TextStyle	*gkrellm_copy_textstyle(TextStyle *);

gint		gkrellm_add_chart_style(Monitor *, gchar *);
gint		gkrellm_add_meter_style(Monitor *, gchar *);
gint		gkrellm_lookup_chart_style_id(gchar *);
gint		gkrellm_lookup_meter_style_id(gchar *);

Style		*gkrellm_meter_style(gint);
Style		*gkrellm_panel_style(gint n);
Style		*gkrellm_chart_style(gint n);
Style		*gkrellm_krell_slider_style(void);
Style		*gkrellm_krell_mini_style(void);

TextStyle 	*gkrellm_chart_textstyle(gint);
TextStyle 	*gkrellm_panel_textstyle(gint);
TextStyle 	*gkrellm_meter_textstyle(gint);
TextStyle 	*gkrellm_chart_alt_textstyle(gint);
TextStyle 	*gkrellm_panel_alt_textstyle(gint);
TextStyle 	*gkrellm_meter_alt_textstyle(gint);

GdkImlibImage 	*gkrellm_bg_chart_image(gint);
GdkImlibImage 	*gkrellm_bg_grid_image(gint);
GdkImlibImage 	*gkrellm_bg_panel_image(gint);
GdkImlibImage 	*gkrellm_bg_meter_image(gint);
GdkImlibImage	*gkrellm_bg_slider_image(gint);

GdkImlibImage 	*gkrellm_krell_panel_image(gint);
GdkImlibImage 	*gkrellm_krell_meter_image(gint);
GdkImlibImage	*gkrellm_krell_slider_image(void);
GdkImlibImage	*gkrellm_krell_mini_image(void);

gboolean	gkrellm_load_image(gchar *, gchar **, GdkImlibImage **, gchar *);
gboolean	gkrellm_set_image_border(gchar *, GdkImlibImage *, Style *);
gboolean	gkrellm_get_gkrellmrc_integer(gchar *, gint *);
gchar		*gkrellm_get_gkrellmrc_string(gchar *);


GdkImlibBorder	*gkrellm_bg_slider_border(gint);

GdkPixmap		*gkrellm_data_in_pixmap();
GdkPixmap		*gkrellm_data_in_grid_pixmap();
GdkPixmap		*gkrellm_data_out_pixmap();
GdkPixmap		*gkrellm_data_out_grid_pixmap();
GdkPixmap		*gkrellm_decal_misc_pixmap(void);
GdkBitmap		*gkrellm_decal_misc_mask(void);

GdkGC			*gkrellm_draw_GC(gint);
GdkGC			*gkrellm_bit_GC(gint);
GdkFont			*gkrellm_default_font(gint);
GdkColor		*gkrellm_white_color(void);
GdkColor		*gkrellm_black_color(void);

gint			gkrellm_update_HZ(void);
gint			gkrellm_scale_mode(void);
gint			gkrellm_chart_width(void);
gint			gkrellm_chart_height(gint);
gint			gkrellm_max_chart_height();

void			gkrellm_monitor_height_adjust(gint);

gboolean gkrellm_using_default_theme(void);
void	gkrellm_config_modified(void);
void	gkrellm_message_window(gchar *title, gchar *message, GtkWidget *);
void	gkrellm_config_message_window(gchar *title, gchar *message,
							GtkWidget *);
void	gkrellm_add_info_text(GtkWidget *, gchar **, gint);
void	gkrellm_add_info_text_string(GtkWidget *, gchar *);

void	gkrellm_chart_images_override(Chart *,GdkImlibImage *,GdkImlibImage *);
void	gkrellm_create_chart(GtkWidget *, Chart *, gint);
void	gkrellm_create_panel(GtkWidget *, Panel *, GdkImlibImage *);
void	gkrellm_configure_panel(Panel *, gchar *, Style *);
void	gkrellm_draw_panel_label(Panel *, GdkImlibImage *);

void	gkrellm_set_decal_button_index(DecalButton *, gint);
DecalButton  *gkrellm_make_decal_button(Panel *, Decal *, void (*func)(),
						void *, gint, gint);
DecalButton *gkrellm_make_overlay_button(Panel *, void (*func)(), void *,
						gint, gint, gint, gint,
						GdkImlibImage *, GdkImlibImage *);
DecalButton *gkrellm_put_decal_in_panel_button(Panel *, Decal *,
						void (*func)(), void *);
DecalButton *gkrellm_put_decal_in_meter_button(Panel *, Decal *,
						void (*func)(), void *);
DecalButton *gkrellm_put_label_in_panel_button(Panel *, void (*func)(),
						void *, gint pad);
DecalButton *gkrellm_put_label_in_meter_button(Panel *, void (*func)(),
						void *, gint pad);
DecalButton *gkrellm_decal_is_button(Decal *);

void	gkrellm_set_in_button_callback(DecalButton *, gint (*func)());
void	gkrellm_destroy_button(DecalButton *);

Krell	*gkrellm_create_krell(Panel *, GdkImlibImage *, Style *);
void	gkrellm_update_krell(Panel *, Krell *, gulong);

Decal	*gkrellm_create_decal_text(Panel *p, gchar *, TextStyle *, Style *,
						gint, gint, gint);
Decal	*gkrellm_create_decal_pixmap(Panel *, GdkPixmap *, GdkBitmap *, gint,
						Style *, gint, gint);
void	gkrellm_draw_decal_pixmap(Panel *, Decal *, gint);
void	gkrellm_draw_decal_text(Panel *, Decal *, gchar *, gint);

void	gkrellm_get_top_bottom_margins(Style *, gint *, gint *);

void	gkrellm_make_decal_visible(Panel *, Decal *);
void	gkrellm_make_decal_invisible(Panel *, Decal *);
gint	gkrellm_is_decal_visible(Decal *);


void	gkrellm_draw_layers(Panel *);
void	gkrellm_draw_layers_force(Panel *);

gint	gkrellm_render_to_pixmap(GdkImlibImage *, GdkPixmap **, GdkBitmap **,
						gint, gint);

void	gkrellm_alloc_chart_data(Chart *);
void	gkrellm_clear_chart(Chart *);
void	gkrellm_store_chart_data(Chart *, gulong, gulong, gulong);
void	gkrellm_draw_chart(Chart *);
void	gkrellm_reset_chart(Chart *);
void	gkrellm_reset_chart_data(Chart *);

void	gkrellm_destroy_chart(Chart *);
void	gkrellm_destroy_panel(Panel *);
void	gkrellm_destroy_krell(Krell *);
void	gkrellm_destroy_decal(Decal *);
void	gkrellm_destroy_krell_list(Panel *);
void	gkrellm_destroy_decal_list(Panel *);

void	gkrellm_pack_side_frames();
int		gkrellm_enable_visibility(int, int *, GtkWidget *, gint);

void	gkrellm_draw_string(GdkDrawable *, TextStyle *, gint, gint, gchar *);
gint	gkrellm_draw_chart_label(Chart *, TextStyle *, gint, gint, gchar *);

void	gkrellm_apply_launcher(GtkWidget **, GtkWidget **, Panel *,
								Launcher *, void (*func)());
GtkWidget *gkrellm_launcher_table_new(GtkWidget *, gint);
void	gkrellm_config_launcher(GtkWidget *, gint, GtkWidget **, GtkWidget **,
								gchar *, Launcher *);
void	gkrellm_setup_launcher(Panel *, Launcher *, gint, gint);
void	gkrellm_configure_tooltip(Panel *, Launcher *);
void	gkrellm_launch_button_cb(DecalButton *);



  /* Some handy utility functions.
  */
GtkWidget *gkrellm_create_tab(GtkWidget *, gchar *);
gchar	*gkrellm_entry_get_text(GtkWidget **);
void	gkrellm_spin_button(GtkWidget *, GtkWidget **, gfloat, gfloat, gfloat,
				gfloat, gfloat, gint, gint, void (*func)(), gpointer,
				gboolean, gchar *);
void	gkrellm_check_button(GtkWidget *, GtkWidget **, gboolean, gboolean,
				gint, gchar *);

gchar	*gkrellm_homedir(void);
gboolean gkrellm_dup_string(gchar **, gchar *);
gchar	*gkrellm_make_config_file_name(gchar *, gchar *);
struct tm *gkrellm_get_current_time();

  /* Session manager plugin helpers.
  */
gint	gkrellm_get_sm_argc(void);
gchar	**gkrellm_get_sm_argv(void);
gint	gkrellm_get_restart_options(gchar **, gint);
void	gkrellm_save_all(void);


/* --- Some builtin monitor public functions --- */

  /* Functions exported by the Mail monitor - see bottom of mail.c */
gboolean gkrellm_get_mail_mute_mode(void);
gpointer gkrellm_add_external_mbox(gint (*func)(), gboolean, gpointer);
void	gkrellm_destroy_external_mbox(gpointer);
void	gkrellm_set_external_mbox_counts(gpointer, gint, gint);
void	gkrellm_set_external_mbox_tooltip(gpointer, gchar *);

  /* Functions exported by sensors.c
  */
gboolean gkrellm_sensors_available(void);
void	gkrellm_sensor_draw_temperature_decal(Panel *, Decal *, gfloat, gchar);
void	gkrellm_sensor_draw_fan_decal(Panel *, Decal *, gfloat);
gint	gkrellm_sensor_read_temperature(gchar *, gfloat *, gchar *);
gint	gkrellm_sensor_read_fan(gchar *, gfloat *);
gint	gkrellm_sensor_read_voltage(gchar *, gfloat *);



/* ---------------- GKrellM 1.1.0 Will Cut Here ------------------ */

/* Name space cleanups.  Probably by release 1.1.0 or so, the above cut
|  will be made.  See Changelog-plugins.html
*/
  /* Use gkrellm_get_top_window() */
extern GtkWidget	*top_window;

  /* Use gkrellm_create_tab()	*/
GtkWidget *create_tab(GtkWidget *, gchar *);

  /* Use gkrellm_homedir()		*/
gchar	*homedir(void);

  /* Use gkrellm_render_to_pixmap()	*/
gint	render_to_pixmap(GdkImlibImage *, GdkPixmap **, GdkBitmap **,
			gint, gint);


  /* Use gkrellm_dup_string()	*/
gboolean dup_string(gchar **, gchar *);
  /* Use gkrellm_entry_get_text()	*/
gchar	*entry_get_alpha_text(GtkWidget **);

  /* As of 0.9.6 I want to move away from these last four routines.
  |  For now I'll keep them around to avoid breaking plugins.
  */
Decal   *gkrellm_create_text_decal(Panel *p, gchar *, TextStyle *, Style *,
                        gint, gint, gint);
Decal   *gkrellm_create_pixmap_decal(Panel *, GdkPixmap *, GdkBitmap *, gint,
                        Style *);
void    gkrellm_draw_pixmap_decal(Panel *, Decal *, gint);
void    gkrellm_draw_text_decal(Panel *, Decal *, gchar *, gint);
