=begin
/****************************************************************
**
** Qt tutorial 10
**
****************************************************************/
=end
require "qt2"
include Qt2

require "lcdrange.rb"
require "cannon.rb"

class MyWidget < QWidget

def initialize  parent=0, name=0
    super( parent, name )
    @quit = QPushButton.new( "Quit", self, "quit" )
    @quit.setFont( QFont.new( "Times", 18, QFont::Bold ) )

    connect( @quit, QSIGNAL("clicked()"), QApplication::qApp, QSLOT("quit()") )

    @angle = LCDRange.new( self, "angle" )
    @angle.setRange( 5, 70 )

    @force = LCDRange.new(self, "force")
    @force.setRange(10,50)

    @cannonField= CannonField.new( self, "cannonField" )

    connect( @angle.valueChanged, @cannonField, "setAngle" )
    connect( @cannonField.angleChanged,  @angle, "setValue" )

    connect( @force.valueChanged, @cannonField, "setForce" )
    connect( @cannonField.forceChanged, @force, "setValue")

    @shoot = QPushButton.new( "&Shoot", self, "shoot" )
    @shoot.setFont( QFont.new( "Times", 18, QFont::Bold ) )

    connect( @shoot, QSIGNAL("clicked()"), @cannonField, "shoot")


    grid = QGridLayout.new( self, 2, 2, 10 )
    #//2x2, 10 pixel border

    grid.addWidget( @quit, 0, 0 )
    grid.addWidget( @cannonField, 1, 1 )
    grid.setColStretch( 1, 10 )

    leftBox = QVBoxLayout.new
    grid.addLayout( leftBox, 1,0)
    leftBox.addWidget( @angle)
    leftBox.addWidget( @force)

    topBox = QHBoxLayout.new
    grid.addLayout( topBox, 0, 1 )
    topBox.addWidget( @shoot )
    topBox.addStretch( 1 )


    @angle.setValue( 60 )
    @force.setValue(25)
    @angle.setFocus()
end
end

    QApplication::setColorSpec( QApplication::CustomColor )

    a = QApplication.new( [$0]+ARGV )

    w = MyWidget.new
    w.setGeometry( 100, 100, 500, 355 )
    a.setMainWidget( $w )
    w.show()
    a.exec()
