/************************************************************************
 *   IRC - Internet Relay Chat, include/channel.h
 *   Copyright (C) 2000 
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __channel_include__
# define __channel_include__
# define MODEBUFLEN             200     /* max modebuf we consider from
                                         * users */
# define REALMODEBUFLEN         512     /* max actual modebuf */
# define MAXMODEPARAMS   6
#endif

extern aChannel *hash_get_chan_bucket(int);
extern aChannel *channel;
extern aChannel *find_channel(char *);
extern aChannel *create_channel(aClient *cptr, char *chname, int *new);
extern aChannel *make_channel();

extern chanMember *make_chanmember(void);
extern chanMember *find_user_member(dlink_list, aClient *);

extern int can_send(aClient *, aChannel *, char *);
extern int set_mode(aClient *, aClient *, aChannel *, int, char **, char *, char *);
extern int can_join(aClient *sptr, aChannel *chptr, char *key);

extern int add_to_channel_hash_table(char *, aChannel *);
extern int del_from_channel_hash_table(char *, aChannel *);

extern void init_channel(void *);
extern void init_chanmodes(void *);

extern void add_user_to_channel(aChannel *, aClient *, int);
extern void remove_user_from_channel(aClient *, aChannel *);
extern void channel_modes(aClient *, char *, char *, aChannel *);
extern void send_user_joins(aClient *, aClient *);
extern void del_invite(aClient *cptr, aChannel *chptr);
extern void send_channel_modes(aClient *, aChannel *);
extern void free_channel(aChannel *);
extern void add_invite(aClient *cptr, aChannel *chptr);
extern void send_names(aClient *sptr, aChannel *chptr);
extern void send_topic_burst(aClient *);
extern void privileged_join(aClient *sptr, aClient *cptr, char *name);

extern void free_chanmember(chanMember *);

#define IsMember(b,c)           ((b && b->user && dlinkFind(&((b->user)->channel), c)) ? 1 : 0)

