/************************************************************************
 *   IRC - Internet Relay Chat, include/confitem.h
 *
 *   Copyright (C) 2000-2002 TR-IRCD Development
 *
 *   Copyright (C) 1995 Philippe Levan
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
 * The dich_conf.h and dich_conf.c were written to provide a generic
 * interface for configuration lines matching. I decided to write it
 * after I read Roy's K: line tree patch. the underlying ideas are the
 * following : . get rid of the left/right branches by using a
 * dichotomy on an ordered list . arrange patterns matching one another
 * in a tree so that if we find a possible match, all other possible
 * matches are "below" These routines are meant for fast matching.
 * There is no notion of "best" of "first" (meaning the order in which
 * the lines are read) match. Therefore, the following functions are
 * fit for K: lines matching but not I: lines matching (as sad as it
 * may be). Other kinds of configuration lines aren't as time consuming
 * or just aren't use for matching so it's irrelevant to try and use
 * these functions for anything else. However, I still made them as
 * generic as possible, just in case.
 * 
 * -Soleil (Philippe Levan)
 * 
 */

#include "fileio.h"

/*
 * $Id: confitem.h,v 5.3 2002/04/26 11:17:26 tr-ircd Exp $ 
 */

extern int rehash(struct Client *, struct Client *, int);
extern int read_conf_old(char *filename);
extern int yylex(void);
extern int conf_yy_fatal_error(char *);
extern int conf_fbgets(char *, int, FBFILE *);

extern void read_conf_files(int cold);
extern void yyerror(char *);

extern FBFILE *conf_fbfile_in;
extern char conf_line_in[256];

extern IP_ENTRY *ip_hash_table[IP_HASH_SIZE];
extern IP_ENTRY *find_or_add_ip(struct irc_inaddr *ip_in);
extern IP_ENTRY *free_ip_entries;

extern aConfList KList1;	/* ordered */
extern aConfList KList2;	/* ordered, reversed */
extern aConfList KList3;	/* what we can't sort */
extern aConfList ZList1;

extern int check_client(struct Client *client_p, struct Client *source_p, char *);
extern int attach_conf(struct Client *, struct ConfItem *);
extern int attach_cn_lines(struct Client *client, char *name, char *host);
extern int attach_Iline(struct Client *client, char *username);
extern int detach_conf(struct Client *, struct ConfItem *);

extern int conf_add_server(struct ConfItem *, int);

extern void clear_ip_hash_table(void);
extern void iphash_stats(struct Client *, struct Client *, int, char **, FBFILE *);
extern void count_ip_hash(int *, u_long *);
extern void remove_one_ip(struct irc_inaddr *ip);
extern void flush_expired_ips(void *);

extern int remove_temp_exclude(char *, char *);
extern int remove_temp_kline(char *host, char *user, int type);

extern char *host_field();
extern char *name_field();
extern char *rev_host_field();
extern char *rev_name_field();

extern char *get_client_name(aClient *, int);
extern char *get_client_host(aClient *);

extern void report_matching_host_klines(aClient *, char *);
extern void report_temp_klines(aClient *, int, char);
extern void report_matching_host_excludes(aClient *, char *);
extern void report_temp_excludes(aClient *);
extern void report_szlines(aClient *);

extern void add_temp_kline(aConfItem *);
extern void add_temp_exclude(aConfItem *);
extern void add_szline(aConfItem *);
extern void remove_szline(char *, int);
extern void free_conf(aConfItem *);
extern void delist_conf(aConfItem *);

extern void add_host_to_oldconf_list(int, char *);
extern void clear_oldconf_list(void);
extern int find_oldconf_type(char *host);

extern void addto_conf_list();
extern void clear_conf_list();
extern void l_addto_conf_list();

extern void conf_add_class_to_conf(struct ConfItem *);
extern void conf_add_class(struct ConfItem *, int);

extern void conf_add_fields(struct ConfItem *, char *, char *, char *, char *);

extern void conf_add_conf(struct ConfItem *);
extern void det_confs_butmask(struct Client *, int);
extern void conf_delist_old_conf(struct ConfItem *);
extern void free_conf(struct ConfItem *);

extern void conf_dns_lookup(struct ConfItem *aconf);
extern void lookup_confhost(struct ConfItem *aconf);

extern void read_conf_files(int cold);

extern void flush_temp_klines(void);
extern void do_rehash_akills(void);
extern void do_rehash_excludes();

extern void do_pending_klines(void *);

extern struct pkl *pending_klines;

extern char *find_or_add(char *);

extern void report_connect_blocks(aClient *sptr, int all);
extern void report_connect_blocks_flag(aClient *sptr, int confflag,
				       int reply, char letter);
extern void report_auth_blocks(aClient *sptr, int onlywhat);
extern void report_operator_blocks(aClient *sptr);
extern void report_service_blocks(aClient *sptr, int all);
extern void report_linked_confs(aClient *sptr, int type, int reply,
				char letter);
extern void report_klines(aClient *sptr, aConfList *List);
extern void report_zlines(aClient *sptr, aConfList *List);
extern void show_opers(aClient *cptr, char *name);
extern void show_servers(aClient *cptr, char *name);
extern void report_protocol(aClient *cptr);

extern aConfItem *GlobalConfItemList;
extern aConfItem *make_conf(void);

extern aConfItem *find_kill(aClient *);
extern aConfItem *find_is_klined(char *, char *, aClient *);
extern aConfItem *find_exclude(aClient *);
extern aConfItem *find_is_excluded(char *, char *, aClient *);
extern aConfItem *find_zkill(aClient *);
extern aConfItem *find_is_zlined(char *);
extern aConfItem *make_conf(void);
extern aConfItem *temporary_klines;
extern aConfItem *temporary_excludes;
extern aConfItem *szlines;
extern aConfItem *find_matching_conf();
extern aConfItem *l_find_matching_conf();

extern struct ConfItem *det_confs_butone(struct Client *, struct ConfItem *);
extern struct ConfItem *find_conf_entry(struct ConfItem *, int);
extern struct ConfItem *find_conf_exact(char *name, char *user, char *host, int statmask);
extern struct ConfItem *find_conf_name(dlink_list * list, char *name, int statmask);
extern struct ConfItem *find_conf_host(dlink_list * list, char *host, int statmask);
extern struct ConfItem *find_conf_ip(dlink_list * list, char *ip, char *name, int);
extern struct ConfItem *find_conf_by_name(char *name, int status);
extern struct ConfItem *find_conf_by_host(char *host, int status);
extern struct ConfItem *find_confitem(dlink_list * list, int statmask);
extern struct ConfItem *find_conf_for_client(aClient *cptr, int status, int flags);
