/*
 *   Copyright (C) 2000-2002 TR-IRCD Development
 *
 *   Copyright (C) 1990 Jarkko Oikarinen and
 *                      University of Oulu, Co Center
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: modules.h,v 5.2 2002/04/05 11:47:50 tr-ircd Exp $
 */

#ifndef INCLUDED_modules_h
#define INCLUDED_modules_h

#ifdef HAVE_SYS_PARAM_H
#include <sys/param.h>
#endif

#define MODPATH IRCD_PREFIX "/lib/modules"
#define LANGPATH IRCD_PREFIX "/lib/languages"
#define CHANMODEPATH IRCD_PREFIX "/lib/chanmodes"

#define LM_MODULES 	0x001
#define LM_LANG		0x002
#define LM_CHANMODES	0x004

struct module {
  char *name;
  char *version;
  void *address;
};

struct module_path
{
        char path[MAXPATHLEN];
};

void mod_add_path(char *path);
void mod_clear_paths(void);

extern void load_module(char *path);
extern void load_all_modules(int which, int check);
extern void load_modules_from(int check, char *frompath);

#ifndef STATIC_MODULES
extern void _modinit(void);
extern void _moddeinit(void);
#endif

extern int unload_one_module (char *, int);
extern int load_one_module (char *);
extern int load_a_module (char *, int);
extern int  findmodule_byname (char *);
extern void init_modules(void);
extern void init_loader(void *);

extern char *irc_basename(char *path);   

extern struct module **modlist;       
    
extern int num_mods;
extern int max_mods;

#if defined(HAVE_SHL_LOAD)
#include <dl.h>
#include <dlfcn.h>
#else
#include <dlfcn.h>
#endif



#endif
