/************************************************************************
 *   IRC - Internet Relay Chat, include/sys.h
 *
 *   Copyright (C) 2000-2002 TR-IRCD Development
 *
 *   Copyright (C) 1990 University of Oulu, Computing Center
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/*
 * $Id: sys.h,v 5.2 2002/04/26 11:17:26 tr-ircd Exp $ 
 */

#ifndef	__sys_include__
# define __sys_include__
# include <sys/errno.h>
# include "setup.h"
# include <stdio.h>
# include <sys/types.h>
# include <sys/param.h>

# if defined( HAVE_UNISTD_H )
#  include <unistd.h>
# endif

# if defined( HAVE_STDLIB_H )
#  include <stdlib.h>
# endif

# if defined( HAVE_STRINGS_H )
#  include <strings.h>
# endif

# if defined( HAVE_STRING_H )
#  include <string.h>
# endif

# if defined( HAVE_LIMITS_H )
#  include <limits.h>
# endif

# define	strcasecmp	irc_strcmp
# define	strncasecmp	irc_strncmp

# include <sys/time.h>

#if ((__GNU_LIBRARY__ == 6) && (__GLIBC__ >=2) && (__GLIBC_MINOR__ >= 2))
#include <time.h>
#endif

extern time_t irc_time(time_t *t);

# ifdef	NO_U_TYPES

typedef unsigned char u_char;
typedef unsigned short u_short;
typedef unsigned long u_long;
typedef unsigned int u_int;

# endif

/*
 * strncopynt --> strncpyzt to avoid confusion, sematics changed N must
 * * be now the number of bytes in the array --msa
 */

#define strncpyzt(x, y, N) do{(void)strncpy(x,y,N);x[N-1]='\0';}while(0)
#define StrEq(x,y)      (!strcmp((x),(y)))

/*
 * inetntoa - optimized inet_ntoa
 */
char* inetntoa(char* in_addr);

/*
 * inetntop()
 * inetpton()
 * portable interfaces for inet_ntop() and inet_pton()
 */
const char *inetntop(int af, const void *src, char *dst, unsigned int size);
int inetpton(int af, const char *src, void *dst);
#define EmptyString(x) (!(x) || (*(x) == '\0'))

/*
 * strip_tabs - convert tabs to spaces
 * - jdc
 */
char *strip_tabs(char *dest, const unsigned char *src, size_t len);

extern char *exploits_2char[];
extern char *exploits_3char[];
extern char *exploits_4char[];

#endif /* __sys_include__ */
