/************************************************************************
 *   IRC - Internet Relay Chat, include/sysvar.h
 *   Copyright (C) 2000 
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

extern int MAXCLIENTS;
extern int callbacks_called;
extern int debuglevel, highest_fd, errno;
extern int dorehash;   
extern int rehashed;   
extern int zline_in_progress;
extern int killnoident;
extern int superiordifference;
extern int protocol_in_use;
extern int refresh_user_links;

extern time_t NOW;
extern time_t last_stat_save;
extern time_t timeofday;
extern time_t pending_kline_time;

extern int user_modes[];
extern int service_info[];
extern int service_modes[];
extern char *replies[];

/* struct */

extern struct Counter Count;
extern struct stats *ircstp;

extern struct capablist my_capabs[];

extern char serveropts[];

extern char version[128], *infotext[];
extern char *generation, *creation, *genesis;
extern char *uname_result[], *ulimit_result[];
extern char *srcchecksums[], *serverchecksums[];
extern char *modulechecksums[], *cmodechecksums[];
extern char *protocolsums[];

extern char *readbuf;
extern char *debugmode;
extern char *configfile;
extern char *klinefile;
extern char *zlinefile;

extern aWhowas *WHOWASHASH[WW_MAX];

extern dlink_list lclient_list;
extern dlink_list serv_list;
extern dlink_list global_serv_list;
extern dlink_list unknown_list;        /* unknown clients ON this server only */
extern dlink_list locoper_list;

extern dlink_list u_conf;	/* compatibility U:Lines */
extern dlink_list h_conf;	/* compatibility H:Lines */
