/************************************************************************
 *   IRC - Internet Relay Chat, include/capabflag.h
 *
 *   Copyright (C) 2000-2002 TR-IRCD Development
 *
 *   Copyright (C) 1990 Jarkko Oikarinen and
 *                      University of Oulu, Co Center
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2, or (at your option)
 *   any later version.
 *    
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software   
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.        
 *
 *
 */

#define HOSTLEN             63  /* Length of hostname. */

#ifdef IPV6
#define HOSTIPLEN	    53
#else
#define HOSTIPLEN           15  /* Length of dotted quad form of IP */
#endif

#define NICKLEN             30
#define MAX_DATE_STRING     32  /* maximum string length for a date
                                 * string */
#define USERLEN             10
#define REALLEN             50
#define TOPICLEN            307
#define KILLLEN             400
#define HELPLEN             400
#define CHANNELLEN          32
#define PASSWDLEN           63
#define KEYLEN              23
#define BUFSIZE             512 /* WARNING: *DONT* CHANGE THIS!!!! */
#define MAXRECIPIENTS       20
#define MAXBANS             100
#define MAXINVITES          100
#define MAXEXCEPTIONS       100
#define MOTDLINELEN         90
#define MAXSILES            10
#define MAXSILELENGTH       128
#define MAXDCCALLOW         10
#define MAXCHANBANS         45
#define MAXSTOPMSGS         45   

#define MAXKILLS            20  
#define MAXWATCH            128   

#define DCC_LINK_ME     0x01    /* This is my dcc allow */
#define DCC_LINK_REMOTE 0x02    /* I need to remove these dcc allows
                                 * from these clients when I die */

#define USERHOST_REPLYLEN       (NICKLEN+HOSTLEN+USERLEN+5)

#define ID_MAP_SIZE 	    4096        /* size of the identity hashmap */
#define IP_HASH_SIZE 	    0x1000

#define MIN_SPAM_NUM 5
#define MIN_SPAM_TIME 60

#define STAT_LOG        -5      /* logfile for -x */
#define STAT_CONNECTING -4
#define STAT_HANDSHAKE  -3  
#define STAT_ME         -2
#define STAT_UNKNOWN    -1
#define STAT_SERVER     0
#define STAT_CLIENT     1
#define STAT_SERVICE    2

#define IsRegisteredUser(x)     ((x)->status == STAT_CLIENT)
#define IsRegistered(x)         ((x)->status >= STAT_SERVER)
#define IsConnecting(x)         ((x)->status == STAT_CONNECTING)
#define IsHandshake(x)          ((x)->status == STAT_HANDSHAKE)
#define IsMe(x)                 ((x)->status == STAT_ME)          
#define IsUnknown(x)            ((x)->status == STAT_UNKNOWN)
#define IsServer(x)             ((x)->status == STAT_SERVER)          
#define IsClient(x)             ((x)->status == STAT_CLIENT)
#define IsLog(x)                ((x)->status == STAT_LOG)          
#define IsService(x)            ((x)->status == STAT_SERVICE)         

#define SetConnecting(x)        ((x)->status = STAT_CONNECTING)
#define SetHandshake(x)         ((x)->status = STAT_HANDSHAKE)
#define SetMe(x)                ((x)->status = STAT_ME)
#define SetUnknown(x)           ((x)->status = STAT_UNKNOWN)
#define SetServer(x)            ((x)->status = STAT_SERVER)
#define SetClient(x)            ((x)->status = STAT_CLIENT)
#define SetLog(x)               ((x)->status = STAT_LOG)             
#define SetService(x)           ((x)->status = STAT_SERVICE)

#define MyConnect(x)            ((x)->fd >= 0)
#define MyClient(x)             (MyConnect(x) && IsClient(x))
#define IsPerson(x)             ((x)->user && IsClient(x))
#define IsPrivileged(x)         (IsAnOper(x) || IsServer(x) || IsService(x) || IsULine(x))

#define FLAGS_PINGSENT     0x000001     /* Unreplied ping sent */
#define FLAGS_DEADSOCKET   0x000002     /* Local socket is dead */
#define FLAGS_KILLED       0x000004     /* Prevents "QUIT" from being
                                         * sent for this */
#define FLAGS_CLOSING      0x000008     /* set when closing to suppress
                                         * errors */
#define FLAGS_CHKACCESS    0x000010     /* ok to check clients access */
#define FLAGS_GOTID        0x000020     /* successful ident lookup
                                         * achieved */
#define FLAGS_SOBSENT      0x000040     /* we've sent an SOB, just have
                                         * to send an EOB */
#define FLAGS_EOBRECV      0x000080     /* we're waiting on an EOB */

#define FLAGS_DOID         0x000100     /* I-lines say must use ident */
#define FLAGS_NORMALEX     0x000200     /* Client exited normally */
#define FLAGS_SENDQEX      0x000400     /* Sendq exceeded */
#define FLAGS_IPHASH       0x000800     /* iphashed this client */
#define FLAGS_SERV_NEGO    0x001000     /* This is a server that has
                                         * passed connection tests, but
                                         * is a stat < 0 for handshake
                                         * purposes */
#define FLAGS_USERBURST    0x002000     /* server in nick/channel
                                         * netburst */
#define FLAGS_TOPICBURST   0x004000     /* server in topic netburst */
#define FLAGS_RC4IN        0x008000     /* This link is rc4 encrypted. */
#define FLAGS_RC4OUT       0x010000     /* This link is rc4 encrypted. */
#define FLAGS_ZIPPED_IN    0x020000     /* This link is gzipped. */
#define FLAGS_ZIPPED_OUT   0x040000     /* This link is gzipped. */
#define FLAGS_EXITED	   0x080000	/* This client's exit has been completed */
#define FLAGS_FLOODDONE	   0x100000	/* This client exited floodding session */

#define FLAGS_BURST     (FLAGS_USERBURST | FLAGS_TOPICBURST)

#define SetAccess(x)            ((x)->flags |= FLAGS_CHKACCESS)            
#define SetNegoServer(x)        ((x)->flags |= FLAGS_SERV_NEGO)            
#define SetRC4OUT(x)            ((x)->flags |= FLAGS_RC4OUT)
#define SetRC4IN(x)             ((x)->flags |= FLAGS_RC4IN)
#define SetZipIn(x)             ((x)->flags |= FLAGS_ZIPPED_IN)
#define SetZipOut(x)            ((x)->flags |= FLAGS_ZIPPED_OUT)
#define SetRestricted(x)        ((x)->flags |= FLAGS_RESTRICTED)
#define SetGotId(x)             ((x)->flags |= FLAGS_GOTID)
#define SetNeedId(x)            ((x)->flags |= FLAGS_DOID)
#define SetIpHash(x)            ((x)->flags |= FLAGS_IPHASH)
#define SetExited(x)		((x)->flags |= FLAGS_EXITED)
#define SetFloodDone(x)		((x)->flags |= FLAGS_FLOODDONE)

#define IsFloodDone(x)		((x)->flags & FLAGS_FLOODDONE)
#define IsGotId(x)              ((x)->flags & FLAGS_GOTID)
#define IsNeedId(x)             ((x)->flags & FLAGS_DOID)
#define IsRestricted(x)         ((x)->flags & FLAGS_RESTRICTED)
#define IsListening(x)          ((x)->flags & FLAGS_LISTEN)
#define IsDead(x)               ((x)->flags & FLAGS_DEADSOCKET)
#define IsNegoServer(x)         ((x)->flags & FLAGS_SERV_NEGO)
#define IsRC4OUT(x)             ((x)->flags & FLAGS_RC4OUT)
#define IsRC4IN(x)              ((x)->flags & FLAGS_RC4IN)
#define ZipIn(x)                ((x)->flags & FLAGS_ZIPPED_IN)
#define ZipOut(x)               ((x)->flags & FLAGS_ZIPPED_OUT)
#define IsExited(x)		((x)->flags & FLAGS_EXITED)

#define ClearNegoServer(x)      ((x)->flags &= ~FLAGS_SERV_NEGO)
#define ClearAccess(x)          ((x)->flags &= ~FLAGS_CHKACCESS)

#define RC4EncLink(x)           (((x)->flags & (FLAGS_RC4IN|FLAGS_RC4OUT)) == (FLAGS_RC4IN|FLAGS_RC4OUT))

/*
 * definitions for get_client_name
 */
#define HIDE_IP 0
#define SHOW_IP 1
#define MASK_IP 2

#define NOT_AUTHORIZED  (-1)
#define SOCKET_ERROR    (-2)
#define I_LINE_FULL     (-3)
#define TOO_MANY        (-4)
#define BANNED_CLIENT   (-5)
#define TOO_FAST        (-6)

/* Protoflags - additional client flags */
#define PFLAGS_TS7         0x000001
#define PFLAGS_ULINE       0x000002     /* client is U-lined */       
#define PFLAGS_ISHUB       0x000004     /* this link is a hub */
#define PFLAGS_HASIDENTITY 0x000008     /* cptr->id.id is a valid sid/uid pair */
#define PFLAGS_TIME_IS_SET 0x000010     /* This link received SVINFO TIME */
#define PFLAGS_DODKEY      0x000020     /* This link is willing Diffie Hellman */
#define PFLAGS_DOZIP       0x000040     /* This link is willing gzip */
#define PFLAGS_DOHIDENAME  0x000080     /* This link is willing its name hidden */
#define PFLAGS_SETTIME     0x000100     /* This link's time will be set */
#define PFLAGS_GETTIME     0x000200     /* This link sets our time */
#define PFLAGS_ZOMBIE	   0x000400	/* This client is a zombie */
#define PFLAGS_ANONYMOUS   0x000800	/* This client is an anonymous client */
#define PFLAGS_OPERMODE	   0x001000	/* This client used an /operdo or /samode */
#define PFLAGS_ALIASED	   0x002000	/* This client wants the aliasname */
#define PFLAGS_DCCNOTICE   0x004000	/* This client has seen the DCC notice */
#define PFLAGS_IPV6HOST	   0x008000	/* This client has Ipv6 Ip */

#define SetTS7(x)               ((x)->protoflags |= PFLAGS_TS7)
#define SetHasID(x)             ((x)->protoflags |= PFLAGS_HASIDENTITY)
#define SetZombie(x)            ((x)->protoflags |= PFLAGS_ZOMBIE)
#define SetAnon(x)		((x)->protoflags |= PFLAGS_ANONYMOUS)
#define SetOperMode(x)		((x)->protoflags |= PFLAGS_OPERMODE)
#define SetDCCNotice(x)         ((x)->protoflags |= PFLAGS_DCCNOTICE)
#define SetClientIpv6(x)	((x)->protoflags |= PFLAGS_IPV6HOST)

#define HasID(x)                ((x)->protoflags & PFLAGS_HASIDENTITY)
#define IsHub(x)                ((x)->protoflags & PFLAGS_ISHUB)
#define IsULine(x)              ((x)->protoflags & PFLAGS_ULINE)
#define DoZipThis(x)            ((x)->protoflags & PFLAGS_DOZIP)
#define WantDKEY(x)             ((x)->protoflags & PFLAGS_DODKEY)
#define IsTS7(x)                ((x)->protoflags & PFLAGS_TS7)
#define WillHideName(x)		((x)->protoflags & PFLAGS_DOHIDENAME)
#define IsZombie(x)             ((x)->protoflags & PFLAGS_ZOMBIE)
#define IsAnon(x)		((x)->protoflags & PFLAGS_ANONYMOUS)
#define UsesAlias(x)		((x)->protoflags & PFLAGS_ALIASED)
#define SeenDCCNotice(x)        ((x)->protoflags & PFLAGS_DCCNOTICE)
#define IsClientIpv6(x)		((x)->protoflags & PFLAGS_IPV6HOST)

#define UnsetHasID(x)           ((x)->protoflags &= ~PFLAGS_HASIDENTITY)
#define ClearZombie(x)          ((x)->protoflags &= ~PFLAGS_ZOMBIE)
#define ClearOperMode(x)	((x)->protoflags &= ~PFLAGS_OPERMODE)

#define IsOperMode(x)           (((x)->protoflags & PFLAGS_OPERMODE) || IsPrivileged(x))

/*
 * Capabilities of the ircd or clients 
 */

#define SM_NATIVE     0x001
#define SM_HALCYON    0x002
#define SM_PELENNOR   0x004
#define SM_COMPAT     0x008


/* Capabilities from Bahamut */

#define CAPAB_TS3       0x0000001       /* Supports the TS3 Protocal */
#define CAPAB_NOQUIT    0x0000002       /* Supports NOQUIT */
#define CAPAB_NSJOIN    0x0000004       /* server supports new smart sjoin */
#define CAPAB_BURST     0x0000008       /* server supports BURST command */
#define CAPAB_UNCONN    0x0000010       /* server supports UNCONNECT */
#define CAPAB_DKEY      0x0000020       /* server supports dh-key exchange */
#define CAPAB_ZIP       0x0000040       /* server supports gz'd links */
#define CAPAB_NICKIP    0x0000080       /* IP in the NICK line? */

/* Capabilities from TR-IRCD3 */

#define CAPAB_DTONE     0x0000100       /* DarkstarTimeMr14C Protocol */

/* Capabilities from TR-IRCD4/Chimera */

#define CAPAB_SERVICES  0x0000200       /* Server uses SERVICE */
#define CAPAB_EXCLUDE   0x0000400       /* autokill exclusions */

/* Capabilities from TR-IRCD5/Kenora */

#define CAPAB_TOKEN1    0x0000800       /* Token V1 Protocol change */  
#define CAPAB_IDENT     0x0001000       /* base64 !prefixed idents */
#define CAPAB_HIDENAME  0x0002000	/* server wants hidden names */
#define CAPAB_TMODE	0x0004000	/* server understands TMODE */

#define CAPAB_TRIRCD4	0x0000700
#define CAPAB_TRIRCD5   0x0007800

#define IsIDCapable(x)  ((x)->capabilities & CAPAB_IDENT)
#define IsTS3(x)        ((x)->capabilities & CAPAB_TS3)
#define IsNoQuit(x)     ((x)->capabilities & CAPAB_NOQUIT)
#define IsSSJoin(x)     ((x)->capabilities & CAPAB_NSJOIN)
#define IsBurst(x)      ((x)->capabilities & CAPAB_BURST)
#define IsUnconnect(x)  ((x)->capabilities & CAPAB_UNCONN)
#define CanDoDKEY(x)    ((x)->capabilities & CAPAB_DKEY)
#define IsZipCapable(x) ((x)->capabilities & CAPAB_ZIP)
#define IsNICKIP(x)     ((x)->capabilities & CAPAB_NICKIP)
#define IsDTone(x)      ((x)->capabilities & CAPAB_DTONE)
#define HasServices(x)  ((x)->capabilities & CAPAB_SERVICES)
#define CanExclude(x)   ((x)->capabilities & CAPAB_EXCLUDE)
#define IsToken1(x)     ((x)->capabilities & CAPAB_TOKEN1)
#define IsTmode(x)	((x)->capabilities & CAPAB_TMODE)

/*
 * defines for check_ctcp results 
 */
#define CTCP_NONE       0
#define CTCP_YES        1
#define CTCP_DCC        2
#define CTCP_DCCSEND    3

#define UMODE_o     0x0001      /* umode +o - Oper */
#define UMODE_n     0x0002      /* Umode +n - routing messages */
#define UMODE_i     0x0004      /* umode +i - Invisible */
#define UMODE_w     0x0008      /* umode +w - hide channels in whois */
#define UMODE_r     0x0010      /* umode +r - registered nick */
#define UMODE_a     0x0020      /* umode +a - Services Admin */
#define UMODE_A     0x0040      /* umode +A - Server Admin */
#define UMODE_x     0x0080      /* umode +x - hidden hostnames */
#define UMODE_R     0x0100      /* umode +R - listen to registered */
#define UMODE_t	    0x0200	/* umode +t - Translate into greeklish */

#define SEND_UMODES (UMODE_i|UMODE_o|UMODE_w|UMODE_r|UMODE_a|UMODE_A|UMODE_x|UMODE_R|UMODE_t)

#define OPER_UMODES (UMODE_o|UMODE_w|UMODE_n)

#define IsInvisible(x)          ((x)->umode & UMODE_i)
#define IsAnOper(x)             ((x)->umode & UMODE_o)            
#define IsRegNick(x)            ((x)->umode & UMODE_r)
#define IsSAdmin(x)             ((x)->umode & UMODE_a)
#define IsAdmin(x)              ((x)->umode & UMODE_A)
#define IsNoNonReg(x)           ((x)->umode & UMODE_R)
#define SendWallops(x)          ((x)->umode & UMODE_w)
#define IsFake(x)               ((x)->umode & UMODE_x)
#define IsRouting(x)		((x)->umode & UMODE_n)
#define IsForeigner(x)		((x)->umode & UMODE_t)

#define SetOper(x)              ((x)->umode |= UMODE_o)
#define SetRegNick(x)           ((x)->umode |= UMODE_r)
#define SetSAdmin(x)            ((x)->umode |= UMODE_a)
#define SetInvisible(x)         ((x)->umode |= UMODE_i)
#define SetWallops(x)           ((x)->umode |= UMODE_w)

#define ClearSAdmin(x)          ((x)->umode &= ~UMODE_a)
#define ClearAdmin(x)           ((x)->umode &= ~UMODE_A)          
#define ClearOper(x)            ((x)->umode &= ~UMODE_o)
#define ClearInvisible(x)       ((x)->umode &= ~UMODE_i)                
#define ClearWallops(x)         ((x)->umode &= ~UMODE_w)      
#define ClearFake(x)            ((x)->umode &= ~UMODE_x)
#define ClearRouting(x)		((x)->umode &= ~UMODE_n)

#define OFLAG_DIE       0x0001      /* Oper can /die the server */     
#define OFLAG_RESTART   0x0002      /* Oper can /restart */    
#define OFLAG_ADMIN     0x0004      /* Admin */
#define OFLAG_SADMIN    0x0008      /* Oper is a services admin */

#define OPCanDie(x)             ((x)->oflag & OFLAG_DIE)
#define OPCanRestart(x)         ((x)->oflag & OFLAG_RESTART)
#define OPIsAdmin(x)            ((x)->oflag & OFLAG_ADMIN)
#define OPIsSAdmin(x)           ((x)->oflag & OFLAG_SADMIN)

#define OPSetDie(x)             ((x)->oflag |= OFLAG_DIE)
#define OPSetRestart(x)         ((x)->oflag |= OFLAG_RESTART)
#define OPSSetAdmin(x)          ((x)->oflag |= OFLAG_ADMIN)
#define OPSSetSAdmin(x)         ((x)->oflag |= OFLAG_SADMIN)

#define OPClearDie(x)           ((x)->oflag &= ~OFLAG_DIE)
#define OPClearRestart(x)       ((x)->oflag &= ~OFLAG_RESTART)
#define OPClearAdmin(x)         ((x)->oflag &= ~OFLAG_ADMIN)
#define OPClearSAdmin(x)        ((x)->oflag &= ~OFLAG_SADMIN)

/*
 * for sendto_lev
 */

#define CCONN_LEV       1
#define REJ_LEV         2
#define SKILL_LEV       3
#define SPY_LEV         4
#define DEBUG_LEV       5
#define FLOOD_LEV       6
#define SPAM_LEV        7
#define DCCSEND_LEV     8
#define SERVICE_LEV     9       /* TRIRCD */
#define SNOTICE_LEV     10      /* TRIRCD */
#define ULINE_LEV       11      /* TRIRCD */

#define NUM_LEV         13      /* TRIRCD - +2 to the last _LEV */

#define T_CCONN_LEV     "SERVER Channel: Clients connecting and exiting"
#define T_REJ_LEV       "SERVER Channel: Rejected connections"
#define T_SKILL_LEV     "SERVER Channel: Server Kills"
#define T_SPY_LEV       "SERVER Channel: Issued server query commands"
#define T_DCCSEND_LEV   "SERVER Channel: Blocked dcc sends"
#define T_FLOOD_LEV     "SERVER Channel: Flood notices"
#define T_SPAM_LEV      "SERVER Channel: Possible Spambots"
#define T_DEBUG_LEV     "SERVER Channel: Debug information notices"
#define T_NOTICE_LEV    "SERVER Channel: Server notices - former umode +s"
#define T_SERVICE_LEV   "SERVER Channel: Notices about connecting services"
#define T_SNOTICE_LEV   "SERVER Channel: Server notices - former umode +so"

#define N_NOTICE        "&NOTICE"
#define N_CONNECT       "&CONNECTS"
#define N_REJECT        "&REJECTED"
#define N_KILL          "&KILLS"
#define N_STAT          "&STATS"      
#define N_DCCSEND       "&DCCSEND"
#define N_FLOOD         "&FLOOD"
#define N_SPAMBOT       "&SPAMBOTS"
#define N_DEBUG         "&DEBUG"
#define N_SERVICE       "&SERVICES"
#define N_SNOTICE       "&SNOTICE"
#define N_ULINE         "#services"

/*
 * defined debugging levels
 */
#define LOG_FATAL  0
#define LOG_CRIT   0
#define LOG_ERROR  1          /* report_error() and other errors that
                                 * are found */
#define LOG_NOTICE 2
#define LOG_INFO   3          /* general usful info */
#define LOG_DEBUG  4          /* anything to do with debugging, ie
                                 * unimportant :) */

/* aconfitem -> status */

#define CONF_CLIENT             0x0001
#define CONF_SERVER             0x0002
#define CONF_SERVICE            0x0004
#define CONF_OPERATOR           0x0008

#define CONF_KILL               0x0010
#define CONF_ZLINE              0x0020
#define CONF_SQLINE             0x0040
#define CONF_SGLINE             0x0080                 
#define CONF_SZLINE             0x0100                 
#define CONF_AKILL              0x0200
#define CONF_GCOS               0x0400
#define CONF_QUARANTINED_NICK   0x0800
#define CONF_QUARANTINED_CHAN   0x1000
#define CONF_JUPECHAN           0x2000
#define CONF_SJUPECHAN          0x4000
#define CONF_EXCLUDE            0x8000

#define CONF_COMPAT_ULINE	0x100000
#define CONF_COMPAT_HUB		0x200000

#define CONF_ILLEGAL            0x80000000

#define CONF_QUARANTINE         (CONF_QUARANTINED_NICK|CONF_QUARANTINED_CHAN)
#define CONF_CLIENT_MASK        (CONF_CLIENT|CONF_SERVICE|CONF_SERVER)

#define IsIllegal(x)            ((x)->status & CONF_ILLEGAL)

#define CONF_FLAGS_EXEMPTKLINE          0x00000001
#define CONF_FLAGS_NOLIMIT              0x00000002
#define CONF_FLAGS_SPOOF_IP             0x00000004
#define CONF_FLAGS_SPOOF_NOTICE         0x00000008
#define CONF_FLAGS_REDIR                0x00000010
#define CONF_FLAGS_RESTRICTED           0x00000020
#define CONF_FLAGS_ALLOW_AUTO_CONN      0x00000040
#define CONF_FLAGS_ENCRYPTED            0x00000080
#define CONF_FLAGS_COMPRESSED           0x00000100
#define CONF_FLAGS_HUB                  0x00000200
#define CONF_FLAGS_ULTIMATE             0x00000400
#define CONF_FLAGS_SET_TIME             0x00000800
#define CONF_FLAGS_GET_TIME             0x00001000

#define IsConfExemptKline(x)    ((x)->flags & CONF_FLAGS_EXEMPTKLINE)
#define IsConfExemptLimits(x)   ((x)->flags & CONF_FLAGS_NOLIMIT)
#define IsConfDoSpoofIp(x)      ((x)->flags & CONF_FLAGS_SPOOF_IP)
#define IsConfSpoofNotice(x)    ((x)->flags & CONF_FLAGS_SPOOF_NOTICE)   
#define IsConfRestricted(x)     ((x)->flags & CONF_FLAGS_RESTRICTED)
#define IsConfEncrypted(x)      ((x)->flags & CONF_FLAGS_ENCRYPTED)
#define IsConfCompressed(x)     ((x)->flags & CONF_FLAGS_COMPRESSED)
#define IsConfHub(x)            ((x)->flags & CONF_FLAGS_HUB)
#define IsConfUltimate(x)       ((x)->flags & CONF_FLAGS_ULTIMATE)  
#define IsConfSettime(x)        ((x)->flags & CONF_FLAGS_SET_TIME) 
#define IsConfGettime(x)        ((x)->flags & CONF_FLAGS_GET_TIME)

/* service's */

#define SMODE_U         0x001
#define SMODE_A         0x002

#define SERVICE_SEE_PREFIX      0x000001
#define SERVICE_SEE_OPERS       0x000002
#define SERVICE_SEE_NICKS       0x000004
#define SERVICE_SEE_QUITS       0x000008
#define SERVICE_SEE_KILLS       0x000010
#define SERVICE_SEE_SERVERS     0x000020
#define SERVICE_SEE_SERVICES    0x000040
#define SERVICE_SEE_SQUITS      0x000080
#define SERVICE_SEE_RNICKS      0x000100                    
#define SERVICE_SEE_UMODES      0x000200
#define SERVICE_SEE_JOINS       0x000400                 
#define SERVICE_SEE_KICKS       0x000800
#define SERVICE_SEE_PARTS       0x001000
#define SERVICE_SEE_MODES       0x002000
#define SERVICE_SEE_TOPIC       0x004000

/* TS7 and Timestamp flags */

#define TS_CURRENT      7       /* current TS protocol version */
#define TS_MIN          3       /* minimum supported TS protocol */
#define TS_DOESTS       0x20000000      /* What the hell is that ?
                                         * -TimeMr14C */
#define DoesTS(x)       ((x)->tsval == TS_DOESTS)

/*
 * Channel related flags
 */              

#define CHFL_CHANOP     0x0001
#define CHFL_VOICE      0x0002
#define CHFL_SJOIN	0x0004	/* Temporary flag to distinguish between existing and new users */
#define CHFL_PROTECT    0x0008
#define CHFL_OWNER      0x0010
#define CHFL_HALFOP     0x0020
#define CHFL_DEOPPED	0x0040

#define CMODE_LIST 0
#define CMODE_ADD  1
#define CMODE_DEL  2

/* 
 * mask types
 */             

#define MTYP_FULL      0x01     /* mask is nick!user@host */
#define MTYP_USERHOST  0x02     /* mask is user@host */
#define MTYP_HOST      0x04     /* mask is host only */
#define MTYP_CHANNEL   0x08     /* mask is a #channel */

#define MODE_NULL       0x0000
#define MODE_CHANOP     CHFL_CHANOP
#define MODE_VOICE      CHFL_VOICE
#define MODE_SJOIN	CHFL_SJOIN
#define MODE_PROTECT    CHFL_PROTECT
#define MODE_OWNER      CHFL_OWNER
#define MODE_HALFOP     CHFL_HALFOP
#define MODE_DEOPPED    CHFL_DEOPPED
#define MODE_PRIVATE    0x0080
#define MODE_SECRET     0x0100
#define MODE_MODERATED  0x0200
#define MODE_TOPICLIMIT 0x0400
#define MODE_INVITEONLY 0x0800
#define MODE_NOPRIVMSGS 0x1000
#define MODE_KEY        0x2000
#define MODE_BAN        0x4000
#define MODE_LIMIT      0x8000
#define MODE_REGISTERED 0x10000
#define MODE_REGONLY    0x20000
#define MODE_NOCOLOR    0x40000
#define MODE_OPERONLY   0x80000
#define MODE_EXTOPIC    0x100000
#define MODE_CHANBAN    0x200000
#define MODE_STOPMSG    0x400000
#define MODE_EXCEPTION  0x800000
#define MODE_INVITE     0x1000000
#define MODE_HIDEOPS    0x2000000
#define MODE_ANONYMOUS  0x4000000
#define MODE_FLOOD	0x8000000

#define MODE_GETSETTER  (MODE_CHANOP|MODE_OWNER|MODE_PROTECT|MODE_HALFOP)
#define MODE_SPEAKABLE  (MODE_CHANOP|MODE_VOICE|MODE_OWNER|MODE_PROTECT|MODE_HALFOP)
#define CHFL_SPEAKABLE  (CHFL_CHANOP|CHFL_VOICE|CHFL_OWNER|MODE_PROTECT|MODE_HALFOP)
#define CHFL_GETSETTER  (CHFL_CHANOP|CHFL_OWNER|CHFL_PROTECT|CHFL_HALFOP)

#define MODE_CHANUSER	0x003B
#define MODE_CHANMODE	0xFFFFF80

#define SecretChannel(x)        ((x) && ((x)->mode.mode & MODE_SECRET))
#define HiddenChannel(x)        ((x) && ((x)->mode.mode & MODE_PRIVATE))
#define ShowChannel(v,c)        (PubChannel(c) || IsMember((v),(c)))
#define PubChannel(x)           (!(x) || ((x)->mode.mode & (MODE_PRIVATE | MODE_SECRET)) == 0)

#define IsChanModerated(x)      ((x)->mode.mode & MODE_MODERATED)
#define IsChanOpTopic(x)        ((x)->mode.mode & MODE_TOPICLIMIT)
#define IsChanInviteonly(x)     ((x)->mode.mode & MODE_INVITEONLY)
#define IsChanNoPriv(x)         ((x)->mode.mode & MODE_NOPRIVMSGS)
#define IsChanKey(x)            ((x)->mode.mode & MODE_KEY)
#define IsChanLimited(x)        ((x)->mode.mode & MODE_LIMIT)
#define IsChanRegistered(x)     ((x)->mode.mode & MODE_REGISTERED)
#define IsChanRegOnly(x)        ((x)->mode.mode & MODE_REGONLY)
#define IsChanNoColor(x)        ((x)->mode.mode & MODE_NOCOLOR)
#define IsChanOperOnly(x)       ((x)->mode.mode & MODE_OPERONLY)
#define IsChanAnon(x)           ((x)->mode.mode & MODE_ANONYMOUS)
#define IsChanHideOps(x)        ((x)->mode.mode & MODE_HIDEOPS)
#define IsChanExTopic(x)        ((x)->mode.mode & MODE_EXTOPIC)
#define IsChanFlood(x)		((x)->mode.mode & MODE_FLOOD)

#define IsChannelName(name)     ((name) && (*(name) == '#' || *(name) == '&'))
#define IsLocalChan(x)          ((x) && (*(x) == '&'))
#define IsGlobalChan(x)         ((x) && (*(x) == '#'))

/*
 * return values for hunt_server() 
 */

#define HUNTED_NOSUCH   (-1)    /* if the hunted server is not found */
#define HUNTED_ISME     0       /* if this server should execute the
                                 * command */
#define HUNTED_PASS     1       /* if message passed onwards
                                 * successfully */

/*
 * used when sending to #mask or $mask 
 */

#define MATCH_SERVER  1
#define MATCH_HOST    2

/*
 * misc defines 
 */

#define ZIP_NEXT_BUFFER -5
#define RC4_NEXT_BUFFER -4
#define FLUSH_BUFFER    -3
#define CLIENT_EXITED    -2

/*
 * internal defines for cptr->sockerr
 */

#define IRCERR_BUFALLOC         -11
#define IRCERR_ZIP              -12
