/*
 *   Copyright (C) 2000-2002 TR-IRCD Development
 *
 *   Copyright (C) 1990 Jarkko Oikarinen and
 *                      University of Oulu, Co Center
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/*
 * $Id: config.h,v 5.1 2002/04/26 11:17:26 tr-ircd Exp $ 
 */

#ifndef	__config_include__
#define	__config_include__

#include "setup.h"

#define	CONFIGFILE	IRCD_PREFIX "/etc/ircd.conf"
#define KLINEFILE	IRCD_PREFIX "/etc/kline.conf"
#define	MOTD		IRCD_PREFIX "/etc/ircd.motd"
#define	SHORTMOTD	IRCD_PREFIX "/etc/ircd.smotd"
#define	LOGFILE		            "/var/log/ircd.log"
#define LINKSFILE	IRCD_PREFIX "/etc/ircd.links"

#define IRCD_PIDFILE                "/var/run/ircd.pid"

#define HELPPATH	IRCD_PREFIX "/share/tr-ircd/help/en_us"

/*
 * LOCKFILE - Exclusive use of ircd.conf and kline.conf during writes
 * 
 * This creates a lockfile prior to writes to ircd.conf or kline.conf, and
 * can be used in conjunction with viconf (included in the tools
 * directory). This prevents loss of data when klines are added while
 * someone is manually editting the file.  File writes will be retried
 * at the next KLINE, ZLINE, REHASH, or after CHECK_PENDING_KLINES
 * minutes have elapsed.
 */

#define LOCKFILE 	            "/tmp/ircd.conf.lock"

#define USE_FAKEHOST

/*
 * Preallocation values for a network
 * -TimeMr14C
 */

#ifndef SMALL_NETS
#define CHANMEMBER_PREALLOCATE  1024
#define CLIENTS_PREALLOCATE     1024
#define CHANNELS_PREALLOCATE    1024
#define LINEBUF_PREALLOCATE     2048
#define THROTTLE_PREALLOCATE    1024
#define DLINK_PREALLOCATE       1024
#else
#define CHANMEMBER_PREALLOCATE  256
#define CLIENTS_PREALLOCATE     256
#define CHANNELS_PREALLOCATE    512
#define LINEBUF_PREALLOCATE     512
#define THROTTLE_PREALLOCATE    256
#define DLINK_PREALLOCATE       256
#endif


#include "defaults.h"

#endif /* __config_include__ */
