#ifndef __HOOK_H_INCLUDED
#define __HOOK_H_INCLUDED

#include "tools.h"

typedef struct
{
	char *name;
	int id;
	dlink_list hooks;
} hook;

/* we don't define the arguments to hookfn, because they can
   vary between different hooks */

typedef int (*hookfn)(void *data);

/* this is used when a hook is called by an m_function
   stand data you'd need in that situation */

struct hook_data 
{
	struct Client *client_p;
	struct Client *source_p;
  	struct Client *aclient_p;
	struct Channel *channel;
	struct ConfItem *confitem;
	struct User *user;
	int parc;
	char **parv;
	char statchar;
	char *name;
	char *mask;
        char *data;
        unsigned int len;
	int check;
};


int hook_add_event(char *);
int hook_add_hook(char *, hookfn *);
int hook_call_event(int, void *);
int hook_del_event(char *);
int hook_del_hook(char *event, hookfn *fn);
void init_hooks(void);
void hook_dump(aClient *);

#endif
