/************************************************************************
 *   IRC - Internet Relay Chat, include/s_conf.h
 *
 *   Copyright (C) 2000-2002 TR-IRCD Development
 *
 *   Copyright (C) 1990 Jarkko Oikarinen and
 *                      University of Oulu, Co Center
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: s_conf.h,v 5.5 2002/04/26 11:17:26 tr-ircd Exp $
 */

#ifndef INCLUDED_s_conf_h
#define INCLUDED_s_conf_h

struct server_options {
   int ts_warn_delta;
   int ts_max_delta;
   int default_kline_time;
   int check_pending_klines;
   int motd_wait;
   int motd_max;
   int client_flood;
   int max_clients;
   int anti_nick_flood;
   int max_nick_time;
   int max_nick_changes;
   int no_away_flood;
   int max_away_time;
   int max_away_count;
   int no_oper_flood;
   int save_maxclient_stats;
   int save_maxclient_stats_time;
   int warn_no_nline;
   int use_remoteconnect;
   int use_registerfilter;
   int show_headers;
   int debugmode;
   int dont_check_qline_remote;
   int short_motd;
   int hub;
   int staffhide;
   int wingate_notice;
   int do_identd;
   int identd_complain;
   int opers_can_choose_fakehost;
   int throttle_time;
   int throttle_count;
   int anti_spambot;
   int min_join_leave_time;
   int max_join_leave_count;
   int join_leave_count_expire_time;
   int oper_spam_countdown;
   int no_oper_jupiter;
   int floodcount;
   char *language;
   char *staffhost;
   char *server_kline_address;
   char *network_kline_address;
   char *monitor_host;
   char *proxy_url;
};

struct server_info {
   char *name;
   char *description;
   char *networkname;
   struct irc_inaddr address;
   struct irc_inaddr address6;
   int specific_ipv4_vhost;
   int specific_ipv6_vhost;
   char *restartpass;
   char *diepass;
   char *displaypass;
   int identity;
   int servermode;
   char *networkdesc;
   char *aliasname;
};

struct services_conf {
   char *operserv_other_host;
   char *chanserv;
   char *nickserv;
   char *memoserv;
   char *operserv;
   char *statserv;
   char *helpserv;
   char *services_name;
   int hide_ulined_servers;
};

struct admin_info {
   char *name;
   char *email;
   char *description;
};

struct channel_conf {
   int modhost;
   int chanban;
   int halfop;
   int floodmode;
   int protected;
   int owners;
   int excepts;
   int invites;
   int no_chanops_when_split;
   int max_channels_per_user;
   char *default_quit_msg;
};

struct server_hide {
   int enable;
   int links_from_file;
   int flatten_links;
   int links_oper_only;
   int links_delay;
};

extern struct server_options ServerOpts;
extern struct server_info ServerInfo;
extern struct services_conf ServicesConf;
extern struct admin_info AdminInfo;
extern struct channel_conf ChannelConf;
extern struct server_hide ServerHide;

#endif /* INCLUDED_s_conf_h */
