/************************************************************************
 *   IRC - Internet Relay Chat, include/users_include.h
 *   Copyright (C) 2000 
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

extern int sortable();

extern char *myctime(time_t), *date(time_t);
extern char *smalldate(time_t);

extern int msg_has_colors(char *);
extern void reverse(char *, char *);

extern int check_for_ctcp(char *, char **);
extern int check_forbidden_words(char *);
extern int check_dccsend(aClient *, aClient *, char *);

extern int is_silenced(aClient *, aClient *);
extern int allow_dcc(aClient *to, aClient *from);

extern int check_channelname(aClient *, unsigned char *);

extern void init_user(void);
extern void init_server(void);

extern int dgets(int, char *, int);
extern int k_isnumber(char *p);
extern int match_ipmask(char *, aClient *);

extern int send_lusers(aClient *, aClient *, int, char **);
extern int add_silence(aClient *sptr, char *mask);
extern int del_silence(aClient *, char *);
extern int send_lusers(aClient *, aClient *, int, char **);
extern int send_supported(aClient *);

extern char *cluster(char *hostname);
extern char *canonize(char *);
extern char *pretty_mask(char *);
extern char *calcmask(char *, char *);
extern char *calcpass(char *, char *);
extern char *stealth_server(char *, char *);
extern char *collapse(char *);

extern void send_szlines(aClient *);
extern void serv_info(aClient *, char *);
extern void send_umode(aClient *, aClient *, int, int, char *);
extern void send_umode_out(aClient *, aClient *, int);
extern void send_capab_to(aClient *, int);

extern int do_numeric(int, aClient *, aClient *, int, char **);
extern int hunt_server(aClient *, aClient *, char *, char *, int, int, char **);

extern void write_links_file(void*);   
