/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyClasses;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.exceptions.BreakJump;
import org.jruby.exceptions.NextException;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.RedoException;
import org.jruby.exceptions.RetryException;
import org.jruby.exceptions.ReturnException;
import org.jruby.exceptions.RubyArgumentException;
import org.jruby.exceptions.RubySecurityException;
import org.jruby.exceptions.ThrowJump;
import org.jruby.javasupport.JavaSupport;
import org.jruby.javasupport.JavaUtil;
import org.jruby.nodes.CRefNode;
import org.jruby.nodes.MAsgnNode;
import org.jruby.nodes.Node;
import org.jruby.nodes.NodeFactory;
import org.jruby.nodes.types.AssignableNode;
import org.jruby.nodes.types.ExecutableNode;
import org.jruby.parser.DefaultRubyParser;
import org.jruby.parser.ParserHelper;
import org.jruby.parser.RubyParser;
import org.jruby.runtime.Callback;
import org.jruby.runtime.RubyBlock;
import org.jruby.runtime.RubyExceptions;
import org.jruby.runtime.RubyFrame;
import org.jruby.runtime.RubyGlobalEntry;
import org.jruby.runtime.RubyIter;
import org.jruby.runtime.RubyMethodCache;
import org.jruby.runtime.RubyRuntime;
import org.jruby.runtime.RubyVarmap;
import org.jruby.runtime.Scope;
import org.jruby.runtime.ScopeStack;
import org.jruby.util.RubyHashMap;
import org.jruby.util.RubyMap;
import org.jruby.util.RubyStack;

public final class Ruby {
    public static final String RUBY_VERSION = "1.6";
    public static final int FIXNUM_CACHE_MAX = 255;
    public RubyFixnum[] fixnumCache = new RubyFixnum[256];
    private RubyMethodCache methodCache;
    public int stackTraces = 0;
    private RubyMap globalMap;
    public LinkedList objectSpace = new LinkedList();
    private int safeLevel = 0;
    private RubyObject nilObject;
    private RubyBoolean trueObject;
    private RubyBoolean falseObject;
    private RubyClasses classes;
    private RubyExceptions exceptions;
    private ParserHelper parserHelper = null;
    private RubyParser rubyParser = null;
    private RubyRuntime runtime = new RubyRuntime(this);
    private RubyObject rubyTopSelf;
    private ScopeStack scope = new ScopeStack(this);
    private Scope topScope = null;
    private RubyVarmap dynamicVars = null;
    private RubyModule rubyClass = null;
    private RubyFrame rubyFrame;
    private RubyFrame topFrame;
    private CRefNode cRef = new CRefNode(null, null);
    private CRefNode topCRef;
    private String sourceFile;
    private int sourceLine;
    private int inEval;
    private boolean verbose;
    private RubyIter iter;
    private RubyBlock block = new RubyBlock(this);
    private RubyModule cBase;
    private int actMethodScope;
    private RubyModule wrapper;
    private RubyStack classStack = new RubyStack(new LinkedList());
    public RubyStack varMapStack = new RubyStack(new LinkedList());
    private boolean initialized = false;
    private JavaSupport javaSupport;
    private Class regexpAdapterClass;

    public Ruby() {
        this.globalMap = new RubyHashMap();
        this.nilObject = RubyObject.nilObject(this);
        this.trueObject = new RubyBoolean(this, true);
        this.falseObject = new RubyBoolean(this, false);
        this.javaSupport = new JavaSupport(this);
        this.methodCache = new RubyMethodCache(this);
    }

    public static Ruby getDefaultInstance(Class regexpAdapterClass) {
        Ruby ruby = new Ruby();
        ruby.setRegexpAdapterClass(regexpAdapterClass);
        ruby.init();
        return ruby;
    }

    public Object evalScript(String script, Class returnClass) {
        RubyObject result = this.getRubyTopSelf().eval(this.getRubyParser().compileJavaString("<script>", script, script.length(), 1));
        return JavaUtil.convertRubyToJava(this, result, returnClass);
    }

    public void printException(Exception exception) {
        if (exception instanceof RaiseException) {
            this.getRuntime().printError(((RaiseException)exception).getActException());
        } else if (exception instanceof ThrowJump) {
            this.getRuntime().printError(((ThrowJump)exception).getNameError());
        } else if (exception instanceof BreakJump) {
            this.getRuntime().getErrorStream().println("break without block.");
        } else if (exception instanceof ReturnException) {
            this.getRuntime().getErrorStream().println("return without block.");
        }
    }

    public Class getRegexpAdapterClass() {
        return this.regexpAdapterClass;
    }

    public void setRegexpAdapterClass(Class iRegexpAdapterClass) {
        this.regexpAdapterClass = iRegexpAdapterClass;
    }

    public RubyClasses getClasses() {
        return this.classes;
    }

    public RubyBoolean getTrue() {
        return this.trueObject;
    }

    public RubyBoolean getFalse() {
        return this.falseObject;
    }

    public RubyObject getNil() {
        return this.nilObject;
    }

    public RubyModule getRubyModule(String name) {
        return (RubyModule)this.classes.getClassMap().get(name);
    }

    public RubyClass getRubyClass(String name) {
        return (RubyClass)this.classes.getClassMap().get(name);
    }

    public RubyClass defineClass(String name, RubyClass superClass) {
        if (superClass == null) {
            superClass = this.getClasses().getObjectClass();
        }
        RubyClass newClass = RubyClass.newClass(this, superClass);
        newClass.setName(name);
        newClass.setRubyClass(superClass.getRubyClass().newSingletonClass());
        newClass.getRubyClass().attachSingletonClass(newClass);
        superClass.funcall("inherited", newClass);
        this.classes.getClassMap().put(name, newClass);
        return newClass;
    }

    public RubyModule defineModule(String name) {
        RubyModule newModule = RubyModule.newModule(this);
        newModule.setName(name);
        this.getClasses().getClassMap().put(name, newModule);
        return newModule;
    }

    public void defineGlobalFunction(String name, Callback method) {
        this.getClasses().getKernelModule().defineModuleFunction(name, method);
    }

    public int getSafeLevel() {
        return this.safeLevel;
    }

    public void setSafeLevel(int safeLevel) {
        this.safeLevel = safeLevel;
    }

    public void secure(int level) {
        if (level <= this.safeLevel) {
            throw new RubySecurityException(this, "Insecure operation '" + this.getRubyFrame().getLastFunc() + "' at level " + this.safeLevel);
        }
    }

    public RubyFixnum getFixnumInstance(long value) {
        return new RubyFixnum(this, value);
    }

    public void defineGlobalConstant(String name, RubyObject value) {
        this.getClasses().getObjectClass().defineConstant(name, value);
    }

    public RubyObject getTopConstant(String id) {
        if (this.getClasses().getClassMap().get(id) != null) {
            return (RubyObject)this.getClasses().getClassMap().get(id);
        }
        return null;
    }

    public boolean isAutoloadDefined(String name) {
        return false;
    }

    public boolean isClassDefined(String name) {
        return this.classes.getClassMap().get(name) != null;
    }

    public RubyMap getGlobalMap() {
        return this.globalMap;
    }

    public void setGlobalMap(RubyMap globalMap) {
        this.globalMap = globalMap;
    }

    public RubyObject setGlobalVar(String name, RubyObject value) {
        return this.getGlobalEntry(name).set(value);
    }

    public RubyObject getGlobalVar(String name) {
        return this.getGlobalEntry(name).get();
    }

    public RubyObject yield(RubyObject value) {
        return this.yield0(value, null, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RubyObject yield0(RubyObject value, RubyObject self, RubyModule klass, boolean acheck) {
        if (!this.isBlockGiven()) {
            throw new RaiseException(this, "LocalJumpError", "yield called out of block");
        }
        RubyVarmap.push(this);
        this.pushClass();
        RubyBlock tmpBlock = this.block.getTmp();
        RubyFrame frame = new RubyFrame(tmpBlock.frame);
        frame.setPrev(this.getRubyFrame());
        this.setRubyFrame(frame);
        CRefNode oldCRef = this.getCRef();
        this.setCRef(this.getRubyFrame().getCbase());
        Scope oldScope = (Scope)this.getScope().getTop();
        this.getScope().setTop(tmpBlock.scope);
        this.block = this.block.prev;
        if ((this.block.flags & 1) != 0) {
            this.setDynamicVars(new RubyVarmap(null, null, tmpBlock.dynamicVars));
        } else {
            this.setDynamicVars(this.block.dynamicVars);
        }
        this.setRubyClass(klass != null ? klass : tmpBlock.klass);
        if (klass == null) {
            self = tmpBlock.self;
        }
        Node node = tmpBlock.body;
        if (tmpBlock.var != null) {
            if (tmpBlock.var == Node.ONE) {
                if (acheck && value != null && value instanceof RubyArray && ((RubyArray)value).getLength() != 0) {
                    throw new RubyArgumentException(this, "wrong # of arguments (" + ((RubyArray)value).getLength() + " for 0)");
                }
            } else {
                if (!(tmpBlock.var instanceof MAsgnNode) && acheck && value != null && value instanceof RubyArray && ((RubyArray)value).getLength() == 1) {
                    value = ((RubyArray)value).entry(0L);
                }
                ((AssignableNode)((Object)tmpBlock.var)).assign(this, self, value, acheck);
            }
        } else if (acheck && value != null && value instanceof RubyArray && ((RubyArray)value).getLength() == 1) {
            value = ((RubyArray)value).entry(0L);
        }
        this.iter.push(tmpBlock.iter);
        try {
            RubyObject rubyObject;
            block25: {
                RubyObject rubyObject2;
                block24: {
                    RubyObject rubyObject3;
                    try {
                        while (true) {
                            try {
                                if (node == null) {
                                    rubyObject3 = this.getNil();
                                    Object var14_15 = null;
                                    break;
                                }
                                if (node instanceof ExecutableNode) {
                                    if (value == null) {
                                        value = RubyArray.newArray(this, 0L);
                                    }
                                    rubyObject2 = ((ExecutableNode)((Object)node)).execute(value, new RubyObject[]{node.getTValue(), self}, this);
                                    break block24;
                                }
                                rubyObject = node.eval(this, self);
                                break block25;
                            }
                            catch (RedoException rExcptn) {
                                continue;
                            }
                            break;
                        }
                    }
                    catch (NextException nExcptn) {
                        RubyObject rubyObject4 = this.getNil();
                        Object var14_18 = null;
                        this.iter.pop();
                        this.popClass();
                        RubyVarmap.pop(this);
                        this.block.setTmp(tmpBlock);
                        this.setRubyFrame(this.getRubyFrame().getPrev());
                        this.setCRef(oldCRef);
                        this.getScope().setTop(oldScope);
                        return rubyObject4;
                    }
                    catch (ReturnException rExcptn) {
                        RubyObject rubyObject5 = rExcptn.getReturnValue();
                        Object var14_19 = null;
                        this.iter.pop();
                        this.popClass();
                        RubyVarmap.pop(this);
                        this.block.setTmp(tmpBlock);
                        this.setRubyFrame(this.getRubyFrame().getPrev());
                        this.setCRef(oldCRef);
                        this.getScope().setTop(oldScope);
                        return rubyObject5;
                    }
                    this.iter.pop();
                    this.popClass();
                    RubyVarmap.pop(this);
                    this.block.setTmp(tmpBlock);
                    this.setRubyFrame(this.getRubyFrame().getPrev());
                    this.setCRef(oldCRef);
                    this.getScope().setTop(oldScope);
                    return rubyObject3;
                }
                Object var14_16 = null;
                this.iter.pop();
                this.popClass();
                RubyVarmap.pop(this);
                this.block.setTmp(tmpBlock);
                this.setRubyFrame(this.getRubyFrame().getPrev());
                this.setCRef(oldCRef);
                this.getScope().setTop(oldScope);
                return rubyObject2;
            }
            Object var14_17 = null;
            this.iter.pop();
            this.popClass();
            RubyVarmap.pop(this);
            this.block.setTmp(tmpBlock);
            this.setRubyFrame(this.getRubyFrame().getPrev());
            this.setCRef(oldCRef);
            this.getScope().setTop(oldScope);
            return rubyObject;
        }
        catch (Throwable throwable) {
            Object var14_20 = null;
            this.iter.pop();
            this.popClass();
            RubyVarmap.pop(this);
            this.block.setTmp(tmpBlock);
            this.setRubyFrame(this.getRubyFrame().getPrev());
            this.setCRef(oldCRef);
            this.getScope().setTop(oldScope);
            throw throwable;
        }
    }

    public RubyObject getRubyTopSelf() {
        return this.rubyTopSelf;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RubyObject iterate(Callback iterateMethod, RubyObject data1, Callback blockMethod, RubyObject data2) {
        Node node = new NodeFactory(this).newIFunc(blockMethod, data2);
        this.getIter().push(1);
        this.getBlock().push(null, node, this.getRubyTopSelf());
        try {
            RubyObject rubyObject;
            while (true) {
                try {
                    rubyObject = iterateMethod.execute(data1, null, this);
                    Object var10_8 = null;
                }
                catch (BreakJump bExcptn) {
                    RubyObject rubyObject2 = this.getNil();
                    Object var10_9 = null;
                    this.getIter().pop();
                    this.getBlock().pop();
                    return rubyObject2;
                }
                catch (ReturnException rExcptn) {
                    RubyObject rubyObject3 = rExcptn.getReturnValue();
                    Object var10_10 = null;
                    this.getIter().pop();
                    this.getBlock().pop();
                    return rubyObject3;
                }
                catch (RetryException rExcptn) {
                    continue;
                }
                break;
            }
            this.getIter().pop();
            this.getBlock().pop();
            return rubyObject;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            this.getIter().pop();
            this.getBlock().pop();
            throw throwable;
        }
    }

    private void callInits() {
        this.classes = new RubyClasses(this);
        this.classes.initCoreClasses();
        this.exceptions = new RubyExceptions(this);
        this.exceptions.initDefaultExceptionClasses();
        this.rubyTopSelf = new RubyObject(this, this.classes.getObjectClass());
    }

    public void init() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.setIter(new RubyIter());
        this.rubyFrame = this.topFrame = new RubyFrame(this);
        this.getScope().push();
        this.topScope = (Scope)this.getScope().getTop();
        this.setActMethodScope(1);
        try {
            this.callInits();
            this.rubyClass = this.getClasses().getObjectClass();
            this.rubyFrame.setSelf(this.rubyTopSelf);
            this.cRef = this.topCRef = new CRefNode(this.getClasses().getObjectClass(), null);
            this.rubyFrame.setCbase(this.cRef);
        }
        catch (Exception excptn) {
            excptn.printStackTrace(this.getRuntime().getErrorStream());
        }
        this.getScope().pop();
        this.getScope().push(this.topScope);
    }

    public ScopeStack getScope() {
        return this.scope;
    }

    public RubyMethodCache getMethodCache() {
        return this.methodCache;
    }

    public String getSourceFile() {
        return this.sourceFile;
    }

    public void setSourceFile(String sourceFile) {
        this.sourceFile = sourceFile;
    }

    public int getSourceLine() {
        return this.sourceLine;
    }

    public void setSourceLine(int sourceLine) {
        this.sourceLine = sourceLine;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean isBlockGiven() {
        return this.getRubyFrame().getIter() != 0;
    }

    public boolean isFBlockGiven() {
        return this.getRubyFrame().getPrev() != null && this.getRubyFrame().getPrev().getIter() != 0;
    }

    public void pushClass() {
        this.classStack.push(this.getRubyClass());
    }

    public void popClass() {
        this.setRubyClass((RubyModule)this.classStack.pop());
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public RubyVarmap getDynamicVars() {
        return this.dynamicVars;
    }

    public void setDynamicVars(RubyVarmap dynamicVars) {
        this.dynamicVars = dynamicVars;
    }

    public RubyModule getRubyClass() {
        return this.rubyClass;
    }

    public void setRubyClass(RubyModule rubyClass) {
        this.rubyClass = rubyClass;
    }

    public ParserHelper getParserHelper() {
        if (this.parserHelper == null) {
            this.parserHelper = new ParserHelper(this);
            this.parserHelper.init();
        }
        return this.parserHelper;
    }

    public RubyParser getRubyParser() {
        if (this.rubyParser == null) {
            this.rubyParser = new DefaultRubyParser(this);
        }
        return this.rubyParser;
    }

    public int getInEval() {
        return this.inEval;
    }

    public void setInEval(int inEval) {
        this.inEval = inEval;
    }

    public RubyFrame getRubyFrame() {
        return this.rubyFrame;
    }

    public void setRubyFrame(RubyFrame rubyFrame) {
        this.rubyFrame = rubyFrame;
    }

    public RubyFrame getTopFrame() {
        return this.topFrame;
    }

    public void setTopFrame(RubyFrame topFrame) {
        this.topFrame = topFrame;
    }

    public CRefNode getCRef() {
        return this.cRef;
    }

    public void setCRef(CRefNode newCRef) {
        this.cRef = newCRef;
    }

    public CRefNode getTopCRef() {
        return this.topCRef;
    }

    public void setTopCRef(CRefNode topCRef) {
        this.topCRef = topCRef;
    }

    public JavaSupport getJavaSupport() {
        return this.javaSupport;
    }

    public RubyIter getIter() {
        return this.iter;
    }

    public void setIter(RubyIter iter) {
        this.iter = iter;
    }

    public RubyBlock getBlock() {
        return this.block;
    }

    public void setBlock(RubyBlock block) {
        this.block = block;
    }

    public RubyModule getCBase() {
        return (RubyModule)this.getRubyFrame().getCbase().getClassValue();
    }

    public void setCBase(RubyModule cBase) {
        this.getRubyFrame().getCbase().setClassValue(cBase);
    }

    public boolean isScope(int scope) {
        return (this.getActMethodScope() & scope) != 0;
    }

    public int getActMethodScope() {
        return this.actMethodScope;
    }

    public void setActMethodScope(int actMethodScope) {
        this.actMethodScope = actMethodScope;
    }

    public RubyModule getWrapper() {
        return this.wrapper;
    }

    public void setWrapper(RubyModule wrapper) {
        this.wrapper = wrapper;
    }

    public RubyRuntime getRuntime() {
        return this.runtime;
    }

    public void setRuntime(RubyRuntime runtime) {
        this.runtime = runtime;
    }

    public RubyExceptions getExceptions() {
        return this.exceptions;
    }

    public void defineHookedVariable(String name, RubyObject value, RubyGlobalEntry.GetterMethod getter, RubyGlobalEntry.SetterMethod setter) {
        RubyGlobalEntry globalEntry = this.getGlobalEntry(name);
        globalEntry.setData(value);
        globalEntry.setGetter(getter != null ? getter : RubyGlobalEntry.valueMethods);
        globalEntry.setSetter(setter != null ? setter : RubyGlobalEntry.valueMethods);
    }

    public void defineVariable(String name, RubyObject value) {
        this.defineHookedVariable(name, value, null, null);
    }

    public void defineReadonlyVariable(String name, RubyObject value) {
        this.defineHookedVariable(name, value, null, RubyGlobalEntry.readonlySetter);
    }

    public void defineVirtualVariable(String name, RubyGlobalEntry.GetterMethod getter, RubyGlobalEntry.SetterMethod setter) {
        getter = getter != null ? getter : RubyGlobalEntry.valueMethods;
        setter = setter != null ? setter : RubyGlobalEntry.readonlySetter;
        this.defineHookedVariable(name, null, getter, setter);
    }

    public RubyGlobalEntry getGlobalEntry(String name) {
        name = name.charAt(0) == '$' ? name : "$" + name;
        RubyGlobalEntry entry = (RubyGlobalEntry)this.getGlobalMap().get(name);
        if (entry == null) {
            entry = new RubyGlobalEntry(this, name);
            this.getGlobalMap().put(name, entry);
        }
        return entry;
    }

    public void initLoad(ArrayList ioAdditionalDirectory) {
        String lRubyHome = System.getProperty("jruby.home");
        String lRubyLib = System.getProperty("jruby.lib");
        int i = ioAdditionalDirectory.size() - 1;
        while (i >= 0) {
            ioAdditionalDirectory.set(i, new RubyString(this, (String)ioAdditionalDirectory.get(i)));
            --i;
        }
        if (lRubyLib != null && lRubyLib.length() != 0) {
            ioAdditionalDirectory.add(new RubyString(this, lRubyLib));
        }
        if (lRubyHome != null && lRubyHome.length() != 0) {
            String lRuby = lRubyHome + File.separatorChar + "lib" + File.separatorChar + "ruby" + File.separatorChar;
            String lSiteRuby = lRuby + "site_ruby";
            String lSiteRubyVersion = lSiteRuby + File.separatorChar + RUBY_VERSION;
            String lArch = File.separatorChar + "JAVA";
            String lRubyVersion = lRuby + RUBY_VERSION;
            ioAdditionalDirectory.add(new RubyString(this, lSiteRubyVersion));
            ioAdditionalDirectory.add(new RubyString(this, lSiteRubyVersion + lArch));
            ioAdditionalDirectory.add(new RubyString(this, lSiteRuby));
            ioAdditionalDirectory.add(new RubyString(this, lRubyVersion));
            ioAdditionalDirectory.add(new RubyString(this, lRubyVersion + lArch));
        }
        ioAdditionalDirectory.add(new RubyString(this, "."));
        RubyArray rb_load_path = new RubyArray(this, ioAdditionalDirectory);
        this.defineReadonlyVariable("$:", rb_load_path);
        this.defineReadonlyVariable("$-I", rb_load_path);
        this.defineReadonlyVariable("$LOAD_PATH", rb_load_path);
        RubyArray rb_features = new RubyArray(this);
        this.defineReadonlyVariable("$\"", rb_features);
    }

    public File findFile(File i2find) {
        RubyArray lLoadPath = (RubyArray)this.getGlobalVar("$:");
        int lPathNb = lLoadPath.getLength();
        String l2Find = i2find.getPath();
        int i = 0;
        while (i < lPathNb) {
            String lCurPath = ((RubyString)lLoadPath.entry(i)).getValue();
            File lCurFile = new File(lCurPath + File.separatorChar + l2Find);
            if (lCurFile.exists()) {
                i2find = lCurFile;
                break;
            }
            ++i;
        }
        if (i2find.exists()) {
            return i2find;
        }
        throw new RuntimeException("file " + i2find.getPath() + " can't be found!");
    }

    static {
        RUBY_VERSION = RUBY_VERSION;
        FIXNUM_CACHE_MAX = 255;
    }
}

